'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getIterator2 = require("babel-runtime/core-js/get-iterator");

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonld = require("jsonld");

var _jsonld2 = _interopRequireDefault(_jsonld);

var _Constants = require("../constants/Constants.js");

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require("../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _Utils = require("./Utils");

var _Utils2 = _interopRequireDefault(_Utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var formShape = {
    root: {},
    expandProperties: [_Constants2.default.HAS_SUBQUESTION, _Constants2.default.IS_RELEVANT_IF]
};
formShape.root[_Constants2.default.HAS_LAYOUT_CLASS] = _Constants2.default.FORM;

var JsonLdFramingUtils = function () {
    function JsonLdFramingUtils() {
        (0, _classCallCheck3.default)(this, JsonLdFramingUtils);
    }

    (0, _createClass3.default)(JsonLdFramingUtils, null, [{
        key: "customFrame",
        //TODO revise


        /**
         * Performs JSON-LD custom framing using shapes. Shape is declaration of the JSON-LD framing
         * in a language that is incompatible with JSON-LD specification.
         *
         * @param input the JSON-LD input to framing by a shape.
         * @param shape the JSON-LD custom frame configuration using shapes.
         * @param callback(err, framed) called once the operation completes.
         */
        value: function customFrame(input, shape, callback) {
            if (arguments.length < 2) {
                return _jsonld2.default.nextTick(function () {
                    callback(new TypeError('Could not frame, too few arguments.'));
                });
            }

            if (shape === null) {
                //TODO remove
                shape = formShape;
            }

            var flattened = null,
                err = null,
                flattenedCallback = function flattenedCallback(e, f) {
                flattened = f;
                err = e;
            };

            _jsonld2.default.flatten(input, null, null, flattenedCallback);
        }
    }, {
        key: "modifyStructure",
        value: function modifyStructure(structure) {

            var defs = structure['@graph'],
                i,
                len,
                item,
                form,
                formElements,
                id2objectMap = {}; // mapping @id -> object

            for (i = 0, len = defs.length; i < len; i++) {
                item = defs[i];
                id2objectMap[item["@id"]] = item;
                if (_FormUtils2.default.isForm(item)) {
                    form = item;
                }
            }

            try {
                this._expandGraph(form, formShape, id2objectMap);
            } catch (e) {
                console.error("Error '" + e + "' occured, while trying to apply frame-ing with custom shape.");
            }

            return;
        }
    }, {
        key: "_expandGraph",
        value: function _expandGraph(parentNode, shape, id2ObjectMap) {
            var props = shape.expandProperties,
                childArray,
                child,
                childId;

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)(shape.expandProperties), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var prop = _step.value;

                    if (parentNode.hasOwnProperty(prop)) {
                        parentNode[prop] = _Utils2.default.asArray(parentNode[prop]);
                        childArray = parentNode[prop];
                        for (var i = 0; i < childArray.length; i++) {
                            childId = childArray[i]["@id"];
                            child = id2ObjectMap[childId];
                            if (child !== undefined) {
                                childArray[i] = child;
                                console.log(childId + " expanded.");
                                this._expandGraph(child, shape, id2ObjectMap);
                            } else {
                                console.warn("object with @id " + childId + " was not defined in input data.");
                            }
                        }
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }]);
    return JsonLdFramingUtils;
}();

exports.default = JsonLdFramingUtils;