'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _Configuration = require('../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require('../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require('./FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Utils = function () {
    function Utils() {
        (0, _classCallCheck3.default)(this, Utils);
    }

    (0, _createClass3.default)(Utils, null, [{
        key: 'getStringHash',


        /**
         * Calculates a simple hash of the specified string, much like usual Java implementations.
         * @param str The string to compute has for
         * @return {number}
         */
        value: function getStringHash(str) {
            var hash = 0,
                strlen = str ? str.length : 0,
                i,
                c;
            if (strlen === 0) {
                return hash;
            }
            for (i = 0; i < strlen; i++) {
                c = str.charCodeAt(i);
                hash = (hash << 5) - hash + c;
                hash = hash & hash; // Convert to 32bit integer
            }
            return hash;
        }

        /**
         * Maps the specified id to a name based on a matching item.
         *
         * This function assumes that the items have been processed by {@link #jsonLdToTypeaheadOption), so the id should
         * be equal to one of the item's 'id' attribute, and if it is, the item's 'name' is returned.
         * @param items The items containing also mapping for the specified value (presumably)
         * @param id The id to map, probably a URI
         */

    }, {
        key: 'idToName',
        value: function idToName(items, id) {
            if (!items) {
                return id;
            }
            for (var i = 0, len = items.length; i < len; i++) {
                if (items[i].id === id) {
                    return items[i].name;
                }
            }
            return id;
        }

        /**
         * Resolves mode for the date time picker.
         * @param question Question specifying the mode
         * @return {*} mode for kbss-react-bootstrap-datetimepicker
         */

    }, {
        key: 'resolveDateTimeMode',
        value: function resolveDateTimeMode(question) {
            if (_FormUtils2.default.isDateTime(question)) {
                return 'datetime';
            } else if (_FormUtils2.default.isDate(question)) {
                return 'date';
            } else if (_FormUtils2.default.isTime(question)) {
                return 'time';
            } else {
                return 'datetime';
            }
        }
    }, {
        key: 'resolveDateTimePickerUiFormat',
        value: function resolveDateTimePickerUiFormat(format) {
            if (format === _Constants2.default.DATETIME_NUMBER_FORMAT) {
                return _Configuration2.default.dateTimeFormat;
            } else {
                return format;
            }
        }

        /**
         * Resolves the specified value as a moment instance.
         * @param question Question supplying context info to the resolution
         * @param value The value to parse
         * @return {*} moment instance
         */

    }, {
        key: 'resolveDateTimeValue',
        value: function resolveDateTimeValue(question, value) {
            if (typeof value === 'number') {
                return (0, _moment2.default)(value);
            }
            if (_FormUtils2.default.isDateTime(question)) {
                return (0, _moment2.default)(value, _Configuration2.default.dateTimeFormat);
            } else if (_FormUtils2.default.isDate(question)) {
                return (0, _moment2.default)(value, _Configuration2.default.dateFormat);
            } else {
                return (0, _moment2.default)(value, _Configuration2.default.timeFormat);
            }
        }

        /**
         * Resolves which format of date/time/datetime value should be used in the datetime picker.
         * @param question Question with format info
         * @param originalValue Value read from answer, not processed by the rendered component
         * @return {*} Format from Configuration
         */

    }, {
        key: 'resolveDateTimeFormat',
        value: function resolveDateTimeFormat(question, originalValue) {
            if (typeof originalValue === 'number') {
                return _Constants2.default.DATETIME_NUMBER_FORMAT;
            }
            if (_FormUtils2.default.isDate(question)) {
                return _Configuration2.default.dateFormat;
            } else if (_FormUtils2.default.isTime(question)) {
                return _Configuration2.default.timeFormat;
            } else {
                return _Configuration2.default.dateTimeFormat;
            }
        }

        /**
         * Wraps passed object into new array if it is not array already.
         * @param object_or_array An object or array.
         * @returns {*} New array containing passed object or passed array.
         */

    }, {
        key: 'asArray',
        value: function asArray(object_or_array) {
            if (!object_or_array) {
                return [];
            }
            if (object_or_array.constructor === Array) {
                return object_or_array;
            }
            return [object_or_array];
        }
    }]);
    return Utils;
}();

exports.default = Utils;