'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FormUtils = function () {
    function FormUtils() {
        (0, _classCallCheck3.default)(this, FormUtils);
    }

    (0, _createClass3.default)(FormUtils, null, [{
        key: "isForm",
        value: function isForm(structure) {
            return _jsonldUtils2.default.hasValue(structure, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.FORM);
        }
    }, {
        key: "isWizardStep",
        value: function isWizardStep(structure) {
            return _jsonldUtils2.default.hasValue(structure, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.WIZARD_STEP);
        }
    }, {
        key: "isSection",
        value: function isSection(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.QUESTION_SECTION);
        }
    }, {
        key: "isTypeahead",
        value: function isTypeahead(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.QUESTION_TYPEAHEAD);
        }
    }, {
        key: "getPossibleValuesQuery",
        value: function getPossibleValuesQuery(question) {
            return _jsonldUtils2.default.getJsonAttValue(question, _Constants2.default.HAS_OPTIONS_QUERY);
        }
    }, {
        key: "isDisabled",
        value: function isDisabled(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DISABLED);
        }
    }, {
        key: "isHidden",
        value: function isHidden(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.HIDDEN);
        }
    }, {
        key: "isTextarea",
        value: function isTextarea(question, answerValue) {
            return answerValue && answerValue.length > _Constants2.default.INPUT_LENGTH_THRESHOLD || _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.TEXTAREA);
        }
    }, {
        key: "isCalendar",
        value: function isCalendar(question) {
            return FormUtils.isDate(question) || FormUtils.isTime(question) || FormUtils.isDateTime(question);
        }
    }, {
        key: "isDate",
        value: function isDate(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DATE);
        }
    }, {
        key: "isTime",
        value: function isTime(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.TIME);
        }
    }, {
        key: "isDateTime",
        value: function isDateTime(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DATETIME);
        }
    }, {
        key: "isCheckbox",
        value: function isCheckbox(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.CHECKBOX);
        }
    }, {
        key: "resolveValue",
        value: function resolveValue(answer) {
            if (!answer) {
                return null;
            }
            if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                return answer[_Constants2.default.HAS_OBJECT_VALUE]['@id'];
            } else {
                return _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_DATA_VALUE);
            }
        }
    }]);
    return FormUtils;
}();

exports.default = FormUtils;