export default class JsonLdObjectUtils {
    static getFirstObject(subject: any, predicate: any): any;
    static compareValues(jsonLdValue1: any, jsonLdValue2: any): any;
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */
    static toplogicalSort(data: any, gtProperty: any): any;
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty,
     * while preserving original order.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */
    static orderPreservingToplogicalSort(data: any, gtProperty: any): any;
    static getCompareLocalizedLabelFunction(intl: any): (a: any, b: any) => 0 | 1 | -1;
    static orderByLocalizedLabels(data: any, intl: any): any;
    /**
     * Evaluates if jsonLdObject has provided id.
     * @param jsonLdObject
     * @param id
     * @returns {boolean}
     */
    static checkId(jsonLdObject: any, id: any): boolean;
}
