export default class FormUtils {
    static isForm(structure: any): any;
    static isWizardStep(structure: any): any;
    static isSection(question: any): any;
    static isAnswerable(question: any): any;
    static isTypeahead(question: any): any;
    static getPossibleValuesQuery(question: any): any;
    static isDisabled(question: any): any;
    static isHidden(question: any): any;
    static isTextarea(question: any, answerValue: any): any;
    static isText(question: any): any;
    static isCalendar(question: any): any;
    static isDate(question: any): any;
    static isTime(question: any): any;
    static isDateTime(question: any): any;
    static isCheckbox(question: any): any;
    static isMaskedInput(question: any): any;
    static isSparqlInput(question: any): any;
    static isTurtleInput(question: any): any;
    static isCollapsed(question: any): any;
    static isEmphasised(question: any): any;
    static getCategory(question: any): string | undefined;
    static resolveValue(answer: any): any;
    static resolveValueObject(answer: any): any;
    static isRelevant(question: any): boolean;
    static hasValidationLogic(question: any): boolean;
    static isValid(question: any): boolean;
    static testOrCondition(condition: any): boolean;
    static testCondition(condition: any): boolean;
    static _getMappedObjectsArray(jsonObjects: any, objectType: any): any;
    static hasAnswer(question: any): boolean;
    /**
     * Resolves which format of date/time/datetime value should be used in the datetime picker.
     * @param question Question with format info
     * @param originalValue Value read from answer, not processed by the rendered component
     * @param options Object with datetime formats
     * @return {*} Format from Configuration
     */
    static resolveDateTimeFormat(question: any, originalValue: any, options: any): any;
}
