export default class JsonLdFramingUtils {
    /**
     * Performs JSON-LD custom framing using shapes. Shape is declaration of the JSON-LD framing
     * in a language that is incompatible with JSON-LD specification.
     *
     * @param input the JSON-LD input to framing by a shape.
     * @param shape the JSON-LD custom frame configuration using shapes.
     * @param callback(err, framed) called once the operation completes.
     */
    static customFrame(input: any, shape: any, callback: any, ...args: any[]): any;
    static expandStructure(structure: any): {};
    static _expandGraph(parentNode: any, shape: any, id2ObjectMap: any): void;
    static _getId(jsonObject: any): any;
    static compressStructure: (rootNode: any) => any;
    static _compressGraph: (parentNode: any, object2IdMap: any, idIncluded: any) => any;
}
