'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jsonldUtils = require('jsonld-utils');

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Constants = require('../../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _InputAnswer = require('./InputAnswer');

var _InputAnswer2 = _interopRequireDefault(_InputAnswer);

var _Logger = require('../../util/Logger');

var _Logger2 = _interopRequireDefault(_Logger);

var _MaskedInput = require('../MaskedInput');

var _MaskedInput2 = _interopRequireDefault(_MaskedInput);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MaskedInputAnswer = function MaskedInputAnswer(props) {
    var question = props.question,
        value = props.value,
        mask = _jsonldUtils2.default.getJsonAttValue(question, _Constants2.default.INPUT_MASK);

    if (!mask) {
        _Logger2.default.warn('Input mask not provided. Falling back to regular input.');
        return _react2.default.createElement(_InputAnswer2.default, props);
    }
    return _react2.default.createElement(_MaskedInput2.default, { mask: mask, value: value, label: props.label, title: props.title, placeholder: props.label,
        onChange: function onChange(e) {
            return props.onChange(e.target.value);
        }, disabled: _FormUtils2.default.isDisabled(question) });
};

MaskedInputAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    answer: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = MaskedInputAnswer;