'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jsonldUtils = require('jsonld-utils');

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Configuration = require('../../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require('../../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var InputAnswer = function InputAnswer(props) {
    var question = props.question,
        answer = props.answer,
        value = props.value;
    // When the value is an object_value, but the layout does not specify neither typeahead nor select,
    // show at least the value's label
    if (answer[_Constants2.default.HAS_OBJECT_VALUE] && answer[_Constants2.default.HAS_OBJECT_VALUE][_jsonldUtils2.default.RDFS_LABEL]) {
        value = _jsonldUtils2.default.getJsonAttValue(answer[_Constants2.default.HAS_OBJECT_VALUE], _jsonldUtils2.default.RDFS_LABEL);
    }
    var inputType = _FormUtils2.default.isTextarea(question, value) ? 'textarea' : 'text';
    return _react2.default.createElement(_Configuration2.default.inputComponent, {
        type: inputType,
        label: props.label,
        title: props.title,
        value: value,
        onChange: function onChange(e) {
            props.onChange(e.target.value);
        },
        disabled: _FormUtils2.default.isDisabled(question),
        rows: 5
    });
};

InputAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    answer: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.string,
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = InputAnswer;