'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof2 = require("babel-runtime/helpers/typeof");

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonld = require("jsonld");

var _jsonld2 = _interopRequireDefault(_jsonld);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Utils = require("./Utils");

var _Utils2 = _interopRequireDefault(_Utils);

var _tsort = require("tsort");

var _tsort2 = _interopRequireDefault(_tsort);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var JsonLdObjectUtils = function () {
    function JsonLdObjectUtils() {
        (0, _classCallCheck3.default)(this, JsonLdObjectUtils);
    }

    (0, _createClass3.default)(JsonLdObjectUtils, null, [{
        key: "getFirstObject",
        value: function getFirstObject(subject, predicate) {
            var values = _jsonld2.default.getValues(subject, predicate);

            if (values.length === 0) {
                //throw "Subject "  + subject[@id] + " does not have any value of property " + predicate;
                return null;
            }
            return values[0];
        }
    }, {
        key: "compareValues",
        value: function compareValues(jsonLdValue1, jsonLdValue2) {
            jsonLdValue1 = (typeof jsonLdValue1 === "undefined" ? "undefined" : (0, _typeof3.default)(jsonLdValue1)) === 'object' ? jsonLdValue1 : { '@value': jsonLdValue1 };
            jsonLdValue2 = (typeof jsonLdValue2 === "undefined" ? "undefined" : (0, _typeof3.default)(jsonLdValue2)) === 'object' ? jsonLdValue2 : { '@value': jsonLdValue2 };

            return _jsonld2.default.compareValues(jsonLdValue1, jsonLdValue2);
        }

        /**
         * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty.
         *
         * This is useful for situations where each item only knows its immediate neighbour in the list.
         * @param data The data to sort, should be an array
         * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
         *
         */

    }, {
        key: "toplogicalSort",
        value: function toplogicalSort(data, gtProperty) {
            var swapped;
            do {
                swapped = false;
                for (var i = 0, len = data.length; i < len; i++) {
                    for (var j = i; j < len; j++) {
                        if (data[i][gtProperty]) {
                            var gtId = (0, _typeof3.default)(data[i][gtProperty]) === 'object' ? data[i][gtProperty]['@id'] : data[i][gtProperty];
                            if (gtId === data[j]['@id']) {
                                var tmp = data[i];
                                data[i] = data[j];
                                data[j] = tmp;
                                swapped = true;
                                break;
                            }
                        }
                    }
                }
            } while (swapped);

            return data;
        }

        /**
         * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty,
         * while preserving original order.
         *
         * This is useful for situations where each item only knows its immediate neighbour in the list.
         * @param data The data to sort, should be an array
         * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
         *
         */

    }, {
        key: "orderPreservingToplogicalSort",
        value: function orderPreservingToplogicalSort(data, gtProperty) {
            var graph = (0, _tsort2.default)(),
                id2ObjectMap = {};

            var _loop = function _loop(i, len) {
                var currentId = data[i]['@id'];
                graph.add(currentId);
                id2ObjectMap[currentId] = data[i];

                _Utils2.default.asArray(data[i][gtProperty]).map(function (val) {
                    return (typeof val === "undefined" ? "undefined" : (0, _typeof3.default)(val)) === 'object' ? val['@id'] : val;
                }).map(function (val) {
                    return [val, currentId];
                }).forEach(function (edge) {
                    return graph.add(edge);
                });
            };

            for (var i = 0, len = data.length; i < len; i++) {
                _loop(i, len);
            }

            var sortedIds = graph.sort();
            for (var _i = 0, _len = sortedIds.length; _i < _len; _i++) {
                data[_i] = id2ObjectMap[sortedIds[_i]];
            }
            return data;
        }
    }, {
        key: "getCompareLocalizedLabelFunction",
        value: function getCompareLocalizedLabelFunction(intl) {
            return function (a, b) {
                var aLabel = _jsonldUtils2.default.getLocalized(a[_jsonldUtils2.default.RDFS_LABEL], intl),
                    bLabel = _jsonldUtils2.default.getLocalized(b[_jsonldUtils2.default.RDFS_LABEL], intl);
                if (aLabel < bLabel) {
                    return -1;
                } else if (aLabel > bLabel) {
                    return 1;
                }
                return 0;
            };
        }
    }]);
    return JsonLdObjectUtils;
}();

exports.default = JsonLdObjectUtils;