'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Configuration = require('../../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CheckboxAnswer = function CheckboxAnswer(props) {
    var question = props.question;
    return _react2.default.createElement(_Configuration2.default.inputComponent, {
        type: 'checkbox',
        label: props.label,
        title: props.title,
        checked: props.value === true || props.value === 'true',
        onChange: function onChange(e) {
            props.onChange(e.target.checked);
        },
        disabled: _FormUtils2.default.isDisabled(question)
    });
};

CheckboxAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.bool]),
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = CheckboxAnswer;