'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jsonldUtils = require('jsonld-utils');

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _reactBootstrapTypeahead = require('react-bootstrap-typeahead');

var _reactBootstrapTypeahead2 = _interopRequireDefault(_reactBootstrapTypeahead);

var _Configuration = require('../../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require('../../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _Utils = require('../../util/Utils');

var _Utils2 = _interopRequireDefault(_Utils);

var _JsonLdObjectUtils = require('../../util/JsonLdObjectUtils');

var _JsonLdObjectUtils2 = _interopRequireDefault(_JsonLdObjectUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TypeaheadAnswer = function (_React$Component) {
    (0, _inherits3.default)(TypeaheadAnswer, _React$Component);

    function TypeaheadAnswer(props) {
        (0, _classCallCheck3.default)(this, TypeaheadAnswer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(TypeaheadAnswer).call(this, props));

        _this._onOptionsLoaded = function (type, options) {
            if (type !== _this._queryHash) {
                return;
            }
            options = _this._processTypeaheadOptions(options);
            var value = _FormUtils2.default.resolveValue(_this.props.answer),
                selected = options.find(function (item) {
                return item.id === value;
            });
            _this.setState({ options: options });
            if (selected) {
                _this.typeahead.selectOption(selected);
            }
        };

        _this._onOptionSelected = function (option) {
            _this.props.onChange(option ? option.id : null);
        };

        _this._queryHash = _Utils2.default.getStringHash(_FormUtils2.default.getPossibleValuesQuery(_this.props.question));
        _this.state = {
            options: _this._queryHash ? _this._processTypeaheadOptions(_Configuration2.default.optionsStore.getOptions(_this._queryHash)) : []
        };
        return _this;
    }

    (0, _createClass3.default)(TypeaheadAnswer, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            var question = this.props.question;
            if (!question[_Constants2.default.HAS_OPTION] && _FormUtils2.default.getPossibleValuesQuery(question)) {
                _Configuration2.default.actions.loadFormOptions(this._queryHash, _FormUtils2.default.getPossibleValuesQuery(question));
            } else {
                this.setState({ options: this._processTypeaheadOptions(question[_Constants2.default.HAS_OPTION]) });
            }
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.unsubscribe = _Configuration2.default.optionsStore.listen(this._onOptionsLoaded);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this.unsubscribe();
        }
    }, {
        key: '_processTypeaheadOptions',
        value: function _processTypeaheadOptions(options) {
            if (!options) {
                return [];
            }
            // sort by label
            options.sort(_JsonLdObjectUtils2.default.getCompareLocalizedLabelFunction(_Configuration2.default.intl));

            // sort by property
            _JsonLdObjectUtils2.default.orderPreservingToplogicalSort(options, _Constants2.default.HAS_PRECEDING_VALUE);
            return _jsonldUtils2.default.processTypeaheadOptions(options);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var value = _Utils2.default.idToName(this.state.options, this.props.value),
                question = this.props.question,
                inputProps = {
                disabled: _FormUtils2.default.isDisabled(question)
            };
            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_reactBootstrapTypeahead2.default, { ref: function ref(c) {
                        return _this2.typeahead = c;
                    }, className: 'form-group form-group-sm', formInputOption: 'id',
                    inputProps: inputProps,
                    title: this.props.title, value: value, label: this.props.label,
                    placeholder: this.props.label, filterOption: 'name', size: 'small',
                    displayOption: 'name', onOptionSelected: this._onOptionSelected, optionsButton: true, allowReset: true,
                    options: this.state.options, customListComponent: _Configuration2.default.typeaheadResultList })
            );
        }
    }]);
    return TypeaheadAnswer;
}(_react2.default.Component);

TypeaheadAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    answer: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.string,
    onChange: _react2.default.PropTypes.func.isRequired
};
exports.default = TypeaheadAnswer;