'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonld = require("jsonld");

var _jsonld2 = _interopRequireDefault(_jsonld);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Configuration = require("../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _DefaultFormGenerator = require("./DefaultFormGenerator");

var _DefaultFormGenerator2 = _interopRequireDefault(_DefaultFormGenerator);

var _FormUtils = require("../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _GeneratedStep = require("../components/GeneratedStep");

var _GeneratedStep2 = _interopRequireDefault(_GeneratedStep);

var _Logger = require("../util/Logger");

var _Logger2 = _interopRequireDefault(_Logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var WizardGenerator = function () {
    function WizardGenerator() {
        (0, _classCallCheck3.default)(this, WizardGenerator);
    }

    (0, _createClass3.default)(WizardGenerator, null, [{
        key: "createDefaultWizard",


        /**
         * Generates a default, one-step wizard.
         *
         * @param data Optional, data for which the wizard should be generated (i.e. the root question)
         * @param title Optional, title of the wizard
         * @param callback Callback called with wizard steps definitions (an array of one element in this case)
         */
        value: function createDefaultWizard(data, title, callback) {
            var steps = WizardGenerator._constructWizardSteps(_DefaultFormGenerator2.default.generateForm(data));
            callback({
                steps: steps,
                title: title
            });
        }

        /**
         * Generates wizard steps from the specified data-enriched template.
         * @param structure The wizard structure in JSON-LD
         * @param data Optional, data for which the wizard will be generated (i.e. the root question)
         * @param title Optional, wizard title
         * @param callback Callback called with generated wizard step definitions when ready
         */

    }, {
        key: "createWizard",
        value: function createWizard(structure, data, title, callback) {
            _jsonld2.default.frame(structure, {}, function (err, framed) {
                if (err) {
                    _Logger2.default.error(err);
                }
                try {
                    var wizardProperties = {
                        steps: WizardGenerator._constructWizardSteps(framed),
                        title: title
                    };
                } catch (e) {
                    WizardGenerator.createDefaultWizard(data, title, callback);
                    return;
                }
                callback(wizardProperties);
            });
        }
    }, {
        key: "_constructWizardSteps",
        value: function _constructWizardSteps(structure) {
            var form = structure['@graph'],
                formElements,
                item,
                steps = [],
                i,
                len;

            for (i = 0, len = form.length; i < len; i++) {
                item = form[i];
                if (_FormUtils2.default.isForm(item)) {
                    form = item;
                    break;
                }
            }
            formElements = form[_Constants2.default.HAS_SUBQUESTION];
            if (!formElements) {
                _Logger2.default.error('Could not find any wizard steps in the received data.');
                throw 'No wizard steps in form';
            }
            for (i = 0, len = formElements.length; i < len; i++) {
                item = formElements[i];
                if (_FormUtils2.default.isWizardStep(item) && !_FormUtils2.default.isHidden(item)) {
                    steps.push({
                        name: _jsonldUtils2.default.getLocalized(item[_jsonldUtils2.default.RDFS_LABEL], _Configuration2.default.intl),
                        component: _GeneratedStep2.default,
                        data: item
                    });
                } else {
                    _Logger2.default.warn('Item is not a wizard step: ' + item);
                }
            }
            // TODO Temporary sorting
            steps.sort(function (a, b) {
                if (a.name < b.name) {
                    return 1;
                } else if (a.name > b.name) {
                    return -1;
                }
                return 0;
            });
            _Configuration2.default.wizardStore.initWizard({
                root: form
            }, steps.map(function (item) {
                return item.data;
            }));
            return steps;
        }
    }]);
    return WizardGenerator;
}();

exports.default = WizardGenerator;