'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Configuration = require('../../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _Constants = require('../../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var InputPropertiesResolver = function () {
    function InputPropertiesResolver() {
        (0, _classCallCheck3.default)(this, InputPropertiesResolver);
    }

    (0, _createClass3.default)(InputPropertiesResolver, null, [{
        key: 'resolveValidationProperties',
        value: function resolveValidationProperties(question) {
            var props = {};
            if (question[_Constants2.default.HAS_VALID_ANSWER] === false) {
                props['validation'] = 'error';
                props['help'] = question[_Constants2.default.HAS_VALIDATION_MESSAGE];
            }
            return props;
        }
    }]);
    return InputPropertiesResolver;
}();

var CheckboxAnswer = function CheckboxAnswer(props) {
    var question = props.question;
    return _react2.default.createElement(_Configuration2.default.inputComponent, (0, _objectAssign2.default)({}, InputPropertiesResolver.resolveValidationProperties(question), {
        type: 'checkbox',
        label: props.label,
        title: props.title,
        checked: props.value === true || props.value === 'true',
        onChange: function onChange(e) {
            props.onChange(e.target.checked);
        },
        disabled: _FormUtils2.default.isDisabled(question)
    }));
};

CheckboxAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.bool]),
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = CheckboxAnswer;