'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _objectWithoutProperties2 = require("babel-runtime/helpers/objectWithoutProperties");

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _getPrototypeOf = require("babel-runtime/core-js/object/get-prototype-of");

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require("babel-runtime/helpers/possibleConstructorReturn");

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require("babel-runtime/helpers/inherits");

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _reactDom = require("react-dom");

var _reactDom2 = _interopRequireDefault(_reactDom);

var _inputmaskCore = require("inputmask-core");

var _inputmaskCore2 = _interopRequireDefault(_inputmaskCore);

var _ReactInputSelection = require("react/lib/ReactInputSelection");

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _Configuration = require("../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var KEYCODE_Z = 90;
var KEYCODE_Y = 89;

function isUndo(e) {
    return e.ctrlKey && e.keyCode === KEYCODE_Z;
}

function isRedo(e) {
    return e.ctrlKey && e.keyCode === KEYCODE_Y;
}

// Copied from https://github.com/insin/react-maskedinput

var MaskedInput = function (_React$Component) {
    (0, _inherits3.default)(MaskedInput, _React$Component);

    function MaskedInput(props) {
        (0, _classCallCheck3.default)(this, MaskedInput);

        var _this = (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(MaskedInput).call(this, props));

        _this._onChange = function (e) {
            var maskValue = _this.mask.getValue();
            if (e.target.value !== maskValue) {
                // Cut or delete operations will have shortened the value
                if (e.target.value.length < maskValue.length) {
                    var sizeDiff = maskValue.length - e.target.value.length;
                    _this._updateMaskSelection();
                    _this.mask.selection.end = _this.mask.selection.start + sizeDiff;
                    _this.mask.backspace();
                }
                var value = _this._getDisplayValue();
                e.target.value = value;
                if (value) {
                    _this._updateInputSelection();
                }
            }
            if (_this.props.onChange) {
                _this.props.onChange(e);
            }
        };

        _this._onKeyDown = function (e) {
            if (isUndo(e)) {
                e.preventDefault();
                if (_this.mask.undo()) {
                    e.target.value = _this._getDisplayValue();
                    _this._updateInputSelection();
                    if (_this.props.onChange) {
                        _this.props.onChange(e);
                    }
                }
            } else if (isRedo(e)) {
                e.preventDefault();
                if (_this.mask.redo()) {
                    e.target.value = _this._getDisplayValue();
                    _this._updateInputSelection();
                    if (_this.props.onChange) {
                        _this.props.onChange(e);
                    }
                }
            } else if (e.key === 'Backspace') {
                e.preventDefault();
                _this._updateMaskSelection();
                if (_this.mask.backspace()) {
                    var value = _this._getDisplayValue();
                    e.target.value = value;
                    if (value) {
                        _this._updateInputSelection();
                    }
                    if (_this.props.onChange) {
                        _this.props.onChange(e);
                    }
                }
            }
        };

        _this._onKeyPress = function (e) {
            // Ignore modified key presses
            // Ignore enter key to allow form submission
            if (e.metaKey || e.altKey || e.ctrlKey || e.key === 'Enter') {
                return;
            }

            e.preventDefault();
            _this._updateMaskSelection();
            if (_this.mask.input(e.key)) {
                e.target.value = _this.mask.getValue();
                _this._updateInputSelection();
                if (_this.props.onChange) {
                    _this.props.onChange(e);
                }
            }
        };

        return _this;
    }

    (0, _createClass3.default)(MaskedInput, [{
        key: "componentWillMount",
        value: function componentWillMount() {
            var options = {
                pattern: this.props.mask,
                value: this.props.value,
                formatCharacters: this.props.formatCharacters
            };
            if (this.props.placeholderChar) {
                options.placeholderChar = this.props.placeholderChar;
            }
            this.mask = new _inputmaskCore2.default(options);
        }
    }, {
        key: "componentWillReceiveProps",
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.mask !== nextProps.mask && this.props.value !== nextProps.mask) {
                // if we get a new value and a new mask at the same time
                // check if the mask.value is still the initial value
                // - if so use the nextProps value
                // - otherwise the `this.mask` has a value for us (most likely from paste action)
                if (this.mask.getValue() === this.mask.emptyValue) {
                    this.mask.setPattern(nextProps.mask, { value: nextProps.value });
                } else {
                    this.mask.setPattern(nextProps.mask, { value: this.mask.getRawValue() });
                }
            } else if (this.props.mask !== nextProps.mask) {
                this.mask.setPattern(nextProps.mask, { value: this.mask.getRawValue() });
            } else if (this.props.value !== nextProps.value) {
                this.mask.setValue(nextProps.value);
            }
        }
    }, {
        key: "componentWillUpdate",
        value: function componentWillUpdate(nextProps) {
            if (nextProps.mask !== this.props.mask) {
                this._updatePattern(nextProps);
            }
        }
    }, {
        key: "componentDidUpdate",
        value: function componentDidUpdate(prevProps) {
            if (prevProps.mask !== this.props.mask && this.mask.selection.start) {
                this._updateInputSelection();
            }
        }
    }, {
        key: "_updatePattern",
        value: function _updatePattern(props) {
            this.mask.setPattern(props.mask, {
                value: this.mask.getRawValue(),
                selection: (0, _ReactInputSelection.getSelection)(this.input)
            });
        }
    }, {
        key: "_updateMaskSelection",
        value: function _updateMaskSelection() {
            this.mask.selection = (0, _ReactInputSelection.getSelection)(this.input);
        }
    }, {
        key: "_updateInputSelection",
        value: function _updateInputSelection() {
            (0, _ReactInputSelection.setSelection)(this.input, this.mask.selection);
        }
    }, {
        key: "_onPaste",
        value: function _onPaste(e) {
            e.preventDefault();
            this._updateMaskSelection();
            // getData value needed for IE also works in FF & Chrome
            if (this.mask.paste(e.clipboardData.getData('Text'))) {
                e.target.value = this.mask.getValue();
                // Timeout needed for IE
                setTimeout(this._updateInputSelection, 0);
                if (this.props.onChange) {
                    this.props.onChange(e);
                }
            }
        }
    }, {
        key: "_getDisplayValue",
        value: function _getDisplayValue() {
            var value = this.mask.getValue();
            return value === this.mask.emptyValue ? '' : value;
        }
    }, {
        key: "focus",
        value: function focus() {
            this.input.focus();
        }
    }, {
        key: "blur",
        value: function blur() {
            this.input.blur();
        }
    }, {
        key: "render",
        value: function render() {
            var _this2 = this;

            var _props = this.props;
            var size = _props.size;
            var placeholder = _props.placeholder;
            var props = (0, _objectWithoutProperties3.default)(_props, ["size", "placeholder"]);

            var patternLength = this.mask.pattern.length;
            return _react2.default.createElement(_Configuration2.default.inputComponent, (0, _objectAssign2.default)({}, props, {
                ref: function ref(r) {
                    if (r) {
                        _this2.input = r.input ? _reactDom2.default.findDOMNode(r.input) : r;
                    }
                },
                maxLength: patternLength,
                onChange: this._onChange,
                onKeyDown: this._onKeyDown,
                onKeyPress: this._onKeyPress,
                onPaste: this._onPaste,
                placeholder: placeholder || this.mask.emptyValue,
                size: size || patternLength,
                value: this._getDisplayValue(),
                type: 'text'
            }));
        }
    }]);
    return MaskedInput;
}(_react2.default.Component);

MaskedInput.propTypes = {
    mask: _react2.default.PropTypes.string.isRequired
};
MaskedInput.defaultProps = {
    value: ''
};
exports.default = MaskedInput;