"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _Configuration = require("../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

var _FormUtils = require("../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Created by blcha on 4.11.16.
 */

var ValidatorFactory = function () {
    function ValidatorFactory() {
        (0, _classCallCheck3.default)(this, ValidatorFactory);
    }

    (0, _createClass3.default)(ValidatorFactory, null, [{
        key: "createValidator",
        value: function createValidator(question) {
            if (question[_Constants2.default.REQUIRES_ANSWER]) {
                if (_FormUtils2.default.isCheckbox(question)) {
                    //TODO revise
                    return ValidatorFactory._generateRequiresAnswerCheckBoxValidator(question);
                }
                return ValidatorFactory._generateRequiresAnswerValidator(question);
            } else {
                return function () {
                    var result = {};
                    result[_Constants2.default.HAS_VALID_ANSWER] = true;
                    delete result[_Constants2.default.HAS_VALIDATION_MESSAGE];
                    return result;
                };
            }
        }
    }, {
        key: "_generateRequiresAnswerValidator",
        value: function _generateRequiresAnswerValidator(question) {
            return function (answer) {
                var val = null;
                if (answer[_Constants2.default.HAS_DATA_VALUE]) {
                    val = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_DATA_VALUE);
                } else if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                    val = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_OBJECT_VALUE, "@id");
                }
                var isValid = val !== null && val !== undefined && val !== "",
                    result = {};
                result[_Constants2.default.HAS_VALID_ANSWER] = isValid;
                result[_Constants2.default.HAS_VALIDATION_MESSAGE] = isValid ? null : _jsonldUtils2.default.getLocalized(question[_jsonldUtils2.default.RDFS_LABEL], _Configuration2.default.intl) + ' is missing a value.';
                return result;
            };
        }
    }, {
        key: "_generateRequiresAnswerCheckBoxValidator",
        value: function _generateRequiresAnswerCheckBoxValidator(question) {
            return function (answer) {
                var val = null;
                if (answer[_Constants2.default.HAS_DATA_VALUE]) {
                    val = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_DATA_VALUE);
                } else if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                    val = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_OBJECT_VALUE, "@id");
                }
                var isValid = val !== null && val !== undefined && val !== "" && val !== false,
                    result = {};
                result[_Constants2.default.HAS_VALID_ANSWER] = isValid;
                result[_Constants2.default.HAS_VALIDATION_MESSAGE] = isValid ? null : _jsonldUtils2.default.getLocalized(question[_jsonldUtils2.default.RDFS_LABEL], _Configuration2.default.intl) + ' must be checked.';
                return result;
            };
        }
    }]);
    return ValidatorFactory;
}();

exports.default = ValidatorFactory;