'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _moment = require("moment");

var _moment2 = _interopRequireDefault(_moment);

var _kbssReactBootstrapDatetimepicker = require("kbss-react-bootstrap-datetimepicker");

var _kbssReactBootstrapDatetimepicker2 = _interopRequireDefault(_kbssReactBootstrapDatetimepicker);

var _Constants = require("../../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _Utils = require("../../util/Utils");

var _Utils2 = _interopRequireDefault(_Utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DateTimeAnswer = function DateTimeAnswer(props) {
    var mode = _Utils2.default.resolveDateTimeMode(props.question),
        value = _Utils2.default.resolveDateTimeValue(props.question, props.value),
        format = _Utils2.default.resolveDateTimeFormat(props.question, props.value),
        pickerUiFormat = _Utils2.default.resolveDateTimePickerUiFormat(format);
    if (!value.isValid()) {
        value = (0, _moment2.default)();
    }
    return _react2.default.createElement(
        "div",
        { style: { position: 'relative' } },
        _react2.default.createElement(
            "label",
            { className: "control-label" },
            props.label
        ),
        _react2.default.createElement(_kbssReactBootstrapDatetimepicker2.default, { mode: mode, format: format, inputFormat: pickerUiFormat,
            inputProps: { title: props.title, bsSize: 'small' },
            onChange: function onChange(date) {
                if (format === _Constants2.default.DATETIME_NUMBER_FORMAT) {
                    props.onChange(Number(date));
                } else {
                    props.onChange(date);
                }
            },
            dateTime: format === _Constants2.default.DATETIME_NUMBER_FORMAT ? value.valueOf() : value.format(format) })
    );
};

DateTimeAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.oneOfType[(_react2.default.PropTypes.string, _react2.default.PropTypes.number)],
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = DateTimeAnswer;