'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var QuestionAnswerProcessor = function () {
    function QuestionAnswerProcessor() {
        (0, _classCallCheck3.default)(this, QuestionAnswerProcessor);
    }

    (0, _createClass3.default)(QuestionAnswerProcessor, null, [{
        key: "buildQuestionAnswerModel",


        /**
         * Builds question answer model from the specified wizard data.
         * @param wizardData Global wizard data
         * @param stepData Data from individual wizard steps
         */
        value: function buildQuestionAnswerModel(wizardData, stepData) {
            var question = {
                subQuestions: []
            };
            var processedQuestion = void 0;
            if (wizardData) {
                question.uri = wizardData.root['@id'];
                question.origin = _jsonldUtils2.default.getJsonAttValue(wizardData.root, _Constants2.default.HAS_QUESTION_ORIGIN, '@id');
            }
            if (stepData) {
                for (var i = 0, len = stepData.length; i < len; i++) {
                    // This will skip questions corresponding to empty steps in the wizard
                    processedQuestion = QuestionAnswerProcessor.processQuestionAnswerHierarchy(stepData[i]);
                    if (processedQuestion) {
                        question.subQuestions.push(processedQuestion);
                    }
                }
            }
            return question;
        }

        /**
         * Transforms the QA hierarchy from JSON-LD-based structure to the object model-based one.
         * @param rootQuestion
         */

    }, {
        key: "processQuestionAnswerHierarchy",
        value: function processQuestionAnswerHierarchy(rootQuestion) {
            if (!rootQuestion) {
                return null;
            }
            return QuestionAnswerProcessor._processQuestion(rootQuestion);
        }
    }, {
        key: "_processQuestion",
        value: function _processQuestion(question) {
            var result = {},
                i,
                len;
            result.uri = question['@id'];
            result.origin = _jsonldUtils2.default.getJsonAttValue(question, _Constants2.default.HAS_QUESTION_ORIGIN, '@id');
            if (question[_Constants2.default.HAS_SUBQUESTION]) {
                result.subQuestions = [];
                for (i = 0, len = question[_Constants2.default.HAS_SUBQUESTION].length; i < len; i++) {
                    result.subQuestions.push(QuestionAnswerProcessor._processQuestion(question[_Constants2.default.HAS_SUBQUESTION][i]));
                }
            }
            if (question[_Constants2.default.HAS_ANSWER]) {
                result.answers = [];
                if (!Array.isArray(question[_Constants2.default.HAS_ANSWER])) {
                    question[_Constants2.default.HAS_ANSWER] = [question[_Constants2.default.HAS_ANSWER]];
                }
                for (i = 0, len = question[_Constants2.default.HAS_ANSWER].length; i < len; i++) {
                    result.answers.push(QuestionAnswerProcessor.processAnswer(question[_Constants2.default.HAS_ANSWER][i]));
                }
            }
            return result;
        }
    }, {
        key: "processAnswer",
        value: function processAnswer(answer) {
            var result = {};
            result.uri = answer['@id'];
            result.origin = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_ANSWER_ORIGIN, '@id');
            if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                result.codeValue = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_OBJECT_VALUE, '@id');
            } else {
                result.textValue = _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_DATA_VALUE);
            }
            return result;
        }

        /**
         * Generates an empty answer for the specified question
         * @param question
         */

    }, {
        key: "generateAnswer",
        value: function generateAnswer(question) {
            var answer = {};
            answer[_Constants2.default.HAS_DATA_VALUE] = '';
            return answer;
        }
    }]);
    return QuestionAnswerProcessor;
}();

exports.default = QuestionAnswerProcessor;