'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jsonldUtils = require('jsonld-utils');

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Configuration = require('../../model/Configuration');

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require('../../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require('../../util/FormUtils');

var _FormUtils2 = _interopRequireDefault(_FormUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SelectAnswer = function (_React$Component) {
    (0, _inherits3.default)(SelectAnswer, _React$Component);

    function SelectAnswer(props) {
        (0, _classCallCheck3.default)(this, SelectAnswer);
        return (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(SelectAnswer).call(this, props));
    }

    (0, _createClass3.default)(SelectAnswer, [{
        key: '_generateSelectOptions',
        value: function _generateSelectOptions(options) {
            var rendered = [];
            options.sort(function (a, b) {
                var aLabel = _jsonldUtils2.default.getJsonAttValue(a, JsonldUtils.RDFS_LABEL),
                    bLabel = _jsonldUtils2.default.getJsonAttValue(b, JsonldUtils.RDFS_LABEL);
                if (aLabel < bLabel) {
                    return -1;
                }
                if (aLabel > bLabel) {
                    return 1;
                }
                return 0;
            });
            for (var i = 0, len = options.length; i < len; i++) {
                rendered.push(_react2.default.createElement(
                    'option',
                    { value: _jsonldUtils2.default.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL),
                        key: 'opt-' + i },
                    _jsonldUtils2.default.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL)
                ));
            }
            return rendered;
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var question = this.props.question;
            return _react2.default.createElement(_Configuration2.default.inputComponent, {
                type: 'select',
                label: this.props.label,
                value: this.props.value,
                title: this.props.title,
                onChange: function onChange(e) {
                    _this2.props.onChange(e.target.value);
                },
                disabled: _FormUtils2.default.isDisabled(question)
            }, this._generateSelectOptions(question[_Constants2.default.HAS_OPTION]));
        }
    }]);
    return SelectAnswer;
}(_react2.default.Component);

SelectAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.string,
    onChange: _react2.default.PropTypes.func.isRequired
};
exports.default = SelectAnswer;