'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactBootstrap = require('react-bootstrap');

var _Constants = require('../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PrefixIcon = function (_React$Component) {
    (0, _inherits3.default)(PrefixIcon, _React$Component);

    function PrefixIcon(props) {
        (0, _classCallCheck3.default)(this, PrefixIcon);

        var _this = (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(PrefixIcon).call(this, props));

        _this.state = {
            show: props.show,
            prefixes: props.prefixes,
            iconClass: props.iconClass,
            glyph: props.glyph
        };
        return _this;
    }

    (0, _createClass3.default)(PrefixIcon, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var p = _react2.default.createElement(
                _reactBootstrap.Popover,
                {
                    id: 'prefixes',
                    title: 'Prefixes' },
                _react2.default.createElement(
                    _reactBootstrap.ListGroup,
                    null,
                    this.state.prefixes.sort(function (l, r) {
                        var res = l[_Constants2.default.PREFIX] < r[_Constants2.default.PREFIX];
                        if (res) return -1;
                        return 1;
                    }).map(function (p) {
                        return _react2.default.createElement(
                            _reactBootstrap.ListGroupItem,
                            { key: p[_Constants2.default.PREFIX] },
                            _react2.default.createElement(
                                'strong',
                                null,
                                p[_Constants2.default.PREFIX]
                            ),
                            ': ',
                            p[_Constants2.default.NAMESPACE]
                        );
                    })
                )
            );
            return _react2.default.createElement(
                _reactBootstrap.OverlayTrigger,
                { trigger: 'click', placement: 'right', overlay: p },
                _react2.default.createElement(_reactBootstrap.Glyphicon, { glyph: this.state.glyph, className: this.state.iconClass,
                    onClick: function onClick() {
                        return _this2.setState({ show: !_this2.state.show });
                    } })
            );
        }
    }]);
    return PrefixIcon;
}(_react2.default.Component);

PrefixIcon.propTypes = {
    prefixes: _react2.default.PropTypes.array.isRequired,
    glyph: _react2.default.PropTypes.string,
    iconClass: _react2.default.PropTypes.string,
    show: _react2.default.PropTypes.bool
};

PrefixIcon.defaultProps = {
    iconClass: '',
    glyph: 'info-sign',
    show: false
};

exports.default = PrefixIcon;