'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require("babel-runtime/core-js/object/get-prototype-of");

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require("babel-runtime/helpers/possibleConstructorReturn");

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require("babel-runtime/helpers/inherits");

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _CheckboxAnswer = require("./answer/CheckboxAnswer");

var _CheckboxAnswer2 = _interopRequireDefault(_CheckboxAnswer);

var _DateTimeAnswer = require("./answer/DateTimeAnswer");

var _DateTimeAnswer2 = _interopRequireDefault(_DateTimeAnswer);

var _InputAnswer = require("./answer/InputAnswer");

var _InputAnswer2 = _interopRequireDefault(_InputAnswer);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Configuration = require("../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _MaskedInputAnswer = require("./answer/MaskedInputAnswer");

var _MaskedInputAnswer2 = _interopRequireDefault(_MaskedInputAnswer);

var _SelectAnswer = require("./answer/SelectAnswer");

var _SelectAnswer2 = _interopRequireDefault(_SelectAnswer);

var _FormUtils = require("../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _TypeaheadAnswer = require("./answer/TypeaheadAnswer");

var _TypeaheadAnswer2 = _interopRequireDefault(_TypeaheadAnswer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Answer = function (_React$Component) {
    (0, _inherits3.default)(Answer, _React$Component);

    function Answer(props) {
        (0, _classCallCheck3.default)(this, Answer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(Answer).call(this, props));

        _this.onValueChange = function (value) {
            var change = (0, _objectAssign2.default)({}, _this.props.answer);
            _this._setValue(change, value);
            _this.props.onChange(_this.props.index, change);
        };

        return _this;
    }

    (0, _createClass3.default)(Answer, [{
        key: "_setValue",
        value: function _setValue(change, value) {
            if (value === null) {
                change[_Constants2.default.HAS_OBJECT_VALUE] = null;
                change[_Constants2.default.HAS_DATA_VALUE] = null;
            } else if (this.props.answer[_Constants2.default.HAS_OBJECT_VALUE] || _FormUtils2.default.isTypeahead(this.props.question)) {
                change[_Constants2.default.HAS_OBJECT_VALUE] = {
                    '@id': value
                };
            } else {
                change[_Constants2.default.HAS_DATA_VALUE] = {
                    '@value': value
                };
            }
        }
    }, {
        key: "render",
        value: function render() {
            var question = this.props.question,
                value = _FormUtils2.default.resolveValue(this.props.answer),
                label = _jsonldUtils2.default.getLocalized(question[_jsonldUtils2.default.RDFS_LABEL], _Configuration2.default.intl),
                title = _jsonldUtils2.default.getLocalized(question[_jsonldUtils2.default.RDFS_COMMENT], _Configuration2.default.intl);
            var component = void 0;

            if (_FormUtils2.default.isTypeahead(question)) {
                component = this._renderTypeahead(value, label, title);
            } else if (Answer._hasOptions(question)) {
                component = this._renderSelect(value, label, title);
            } else if (_FormUtils2.default.isCalendar(question)) {
                component = this._renderDateTimePicker(value, label, title);
            } else if (_FormUtils2.default.isCheckbox(question)) {
                component = this._renderCheckbox(value, label, title);
            } else if (_FormUtils2.default.isMaskedInput(question)) {
                component = this._renderMaskedInput(value, label, title);
            } else if (_FormUtils2.default.isSparqlInput(question)) {
                component = this._renderSparqlInput(value, label, title);
            } else if (_FormUtils2.default.isTurtleInput(question)) {
                component = this._renderTurtleInput(value, label, title);
            } else {
                component = this._renderRegularInput(value, label, title);
            }
            return component;
        }
    }, {
        key: "_renderTypeahead",
        value: function _renderTypeahead(value, label, title) {
            return _react2.default.createElement(_TypeaheadAnswer2.default, { question: this.props.question, answer: this.props.answer, label: label, title: title,
                value: value, onChange: this.onValueChange });
        }
    }, {
        key: "_renderSelect",
        value: function _renderSelect(value, label, title) {
            return _react2.default.createElement(_SelectAnswer2.default, { question: this.props.question, label: label, title: title, value: value,
                onChange: this.onValueChange });
        }
    }, {
        key: "_renderDateTimePicker",
        value: function _renderDateTimePicker(value, label, title) {
            return _react2.default.createElement(_DateTimeAnswer2.default, { question: this.props.question, value: value, title: title, label: label,
                onChange: this.onValueChange });
        }
    }, {
        key: "_renderCheckbox",
        value: function _renderCheckbox(value, label, title) {
            return _react2.default.createElement(_CheckboxAnswer2.default, { label: label, title: title, value: value, onChange: this.onValueChange,
                question: this.props.question });
        }
    }, {
        key: "_renderMaskedInput",
        value: function _renderMaskedInput(value, label, title) {
            return _react2.default.createElement(_MaskedInputAnswer2.default, { label: label, title: title, value: value, onChange: this.onValueChange,
                question: this.props.question, answer: this.props.answer });
        }
    }, {
        key: "_renderRegularInput",
        value: function _renderRegularInput(value, label, title) {
            return _react2.default.createElement(_InputAnswer2.default, { question: this.props.question, answer: this.props.answer, label: label, title: title,
                value: value, onChange: this.onValueChange });
        }
    }, {
        key: "_renderSparqlInput",
        value: function _renderSparqlInput(value, label, title) {
            return _react2.default.createElement(_InputAnswer2.default, { question: this.props.question, answer: this.props.answer, label: label, title: title,
                value: value, onChange: this.onValueChange, sparql: true });
        }
    }, {
        key: "_renderTurtleInput",
        value: function _renderTurtleInput(value, label, title) {
            return _react2.default.createElement(_InputAnswer2.default, { question: this.props.question, answer: this.props.answer, label: label, title: title,
                value: value, onChange: this.onValueChange, turtle: true });
        }
    }], [{
        key: "_hasOptions",
        value: function _hasOptions(item) {
            return item[_Constants2.default.HAS_OPTION] && item[_Constants2.default.HAS_OPTION].length !== 0;
        }
    }]);
    return Answer;
}(_react2.default.Component);

Answer.propTypes = {
    answer: _react2.default.PropTypes.object.isRequired,
    question: _react2.default.PropTypes.object.isRequired,
    onChange: _react2.default.PropTypes.func.isRequired,
    index: _react2.default.PropTypes.number
};
exports.default = Answer;