"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require("babel-runtime/core-js/object/get-prototype-of");

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require("babel-runtime/helpers/possibleConstructorReturn");

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require("babel-runtime/helpers/inherits");

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MediaContent = function (_React$Component) {
    (0, _inherits3.default)(MediaContent, _React$Component);

    function MediaContent(props) {
        (0, _classCallCheck3.default)(this, MediaContent);
        return (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(MediaContent).call(this, props));
    }

    (0, _createClass3.default)(MediaContent, [{
        key: "render",
        value: function render() {
            var mediaContent = _jsonldUtils2.default.getJsonAttValue(this.props.question, _Constants2.default.HAS_MEDIA_CONTENT);
            if (!mediaContent) {
                return null;
            }
            return this._renderDangerously(mediaContent);
        }
    }, {
        key: "_renderDangerously",
        value: function _renderDangerously(mediaContent) {
            if (Array.isArray(mediaContent)) {
                return _react2.default.createElement(
                    "div",
                    { className: "col-xs-6" },
                    mediaContent.map(function (src) {
                        return _react2.default.createElement(
                            "div",
                            { key: 'media-' + src, className: "row embed-responsive-21by9 media-content-video-container" },
                            MediaContent.iframe(src)
                        );
                    })
                );
            } else {
                return _react2.default.createElement(
                    "div",
                    { className: "row" },
                    _react2.default.createElement(
                        "div",
                        { className: "col-xs-6 embed-responsive-21by9 media-content-video-container" },
                        MediaContent.iframe(mediaContent)
                    )
                );
            }
        }
    }], [{
        key: "iframe",
        value: function iframe(src) {
            return _react2.default.createElement("iframe", { src: src, className: "embed-responsive-item", allowFullScreen: true });
        }
    }]);
    return MediaContent;
}(_react2.default.Component);

MediaContent.propTypes = {
    question: _propTypes2.default.object.isRequired
};
exports.default = MediaContent;