'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getOwnPropertyNames = require("babel-runtime/core-js/object/get-own-property-names");

var _getOwnPropertyNames2 = _interopRequireDefault(_getOwnPropertyNames);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Configuration = require("../../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require("../../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require("../../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _yasguiYasqe = require("yasgui-yasqe");

var _yasguiYasqe2 = _interopRequireDefault(_yasguiYasqe);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NUMERIC_DATATYPES = [_Constants2.default.XSD.INT, _Constants2.default.XSD.INTEGER, _Constants2.default.XSD.NON_NEGATIVE_INTEGER, _Constants2.default.XSD.NON_POSITIVE_INTEGER, _Constants2.default.XSD.NEGATIVE_INTEGER, _Constants2.default.XSD.POSITIVE_INTEGER];

var DECLARED_PREFIXES = "http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix";

var NUMBER_RULES = {};
NUMBER_RULES[_Constants2.default.XSD.NON_NEGATIVE_INTEGER] = { min: 0 };
NUMBER_RULES[_Constants2.default.XSD.NON_POSITIVE_INTEGER] = { max: 0 };
NUMBER_RULES[_Constants2.default.XSD.NEGATIVE_INTEGER] = { max: -1 };
NUMBER_RULES[_Constants2.default.XSD.POSITIVE_INTEGER] = { min: 1 };

var tokenTypes = {
    "string-2": "prefixed",
    atom: "var"
};

var InputPropertiesResolver = function () {
    function InputPropertiesResolver() {
        (0, _classCallCheck3.default)(this, InputPropertiesResolver);
    }

    (0, _createClass3.default)(InputPropertiesResolver, null, [{
        key: "_resolveInputType",
        value: function _resolveInputType(question, value) {
            if (_FormUtils2.default.isSparqlInput(question) || _FormUtils2.default.isTurtleInput(question) || _FormUtils2.default.isTextarea(question, value)) {
                return 'textarea';
            } else if (InputPropertiesResolver._isNumeric(question)) {
                return 'number';
            } else {
                return 'text';
            }
        }
    }, {
        key: "_isNumeric",
        value: function _isNumeric(question) {
            for (var i = 0, len = NUMERIC_DATATYPES.length; i < len; i++) {
                if (_jsonldUtils2.default.hasValue(question, _Constants2.default.HAS_DATATYPE, NUMERIC_DATATYPES[i])) {
                    return true;
                }
            }
            return false;
        }
    }, {
        key: "resolveInputProperties",
        value: function resolveInputProperties(question, value) {
            var props = {};
            props.type = InputPropertiesResolver._resolveInputType(question, value);
            switch (props['type']) {
                case 'textarea':
                    props.rows = 5;
                    break;
                case 'number':
                    (0, _objectAssign2.default)(props, InputPropertiesResolver._resolveNumberRestrictions(question));
                    break;
                default:
                    break;
            }
            props.disabled = _FormUtils2.default.isDisabled(question);
            if (question[_Constants2.default.HAS_VALID_ANSWER] === false) {
                props.validation = 'error';
                props.help = question[_Constants2.default.HAS_VALIDATION_MESSAGE];
            }

            return props;
        }
    }, {
        key: "_resolveNumberRestrictions",
        value: function _resolveNumberRestrictions(question) {
            var restriction = {};
            (0, _getOwnPropertyNames2.default)(NUMBER_RULES).forEach(function (key) {
                if (_jsonldUtils2.default.hasValue(question, _Constants2.default.HAS_DATATYPE, key)) {
                    (0, _objectAssign2.default)(restriction, NUMBER_RULES[key]);
                }
            });
            if (question[_Constants2.default.XSD.MIN_INCLUSIVE] !== undefined) {
                restriction['min'] = question[_Constants2.default.XSD.MIN_INCLUSIVE];
            }
            if (question[_Constants2.default.XSD.MIN_EXCLUSIVE] !== undefined) {
                restriction['min'] = question[_Constants2.default.XSD.MIN_EXCLUSIVE] + 1;
            }
            if (question[_Constants2.default.XSD.MAX_EXCLUSIVE] !== undefined) {
                restriction['max'] = question[_Constants2.default.XSD.MAX_EXCLUSIVE] - 1;
            }
            if (question[_Constants2.default.XSD.MAX_INCLUSIVE] !== undefined) {
                restriction['max'] = question[_Constants2.default.XSD.MAX_INCLUSIVE];
            }
            return restriction;
        }
    }]);
    return InputPropertiesResolver;
}();

var InputAnswer = function InputAnswer(props) {
    var question = props.question,
        answer = props.answer;
    var value = props.value;
    // When the value is an object_value, but the layout does not specify neither typeahead nor select,
    // show at least the value's label
    if (answer[_Constants2.default.HAS_OBJECT_VALUE] && answer[_Constants2.default.HAS_OBJECT_VALUE][_jsonldUtils2.default.RDFS_LABEL]) {
        value = _jsonldUtils2.default.getJsonAttValue(answer[_Constants2.default.HAS_OBJECT_VALUE], _jsonldUtils2.default.RDFS_LABEL);
    }
    return _react2.default.createElement(_Configuration2.default.inputComponent, (0, _objectAssign2.default)({}, InputPropertiesResolver.resolveInputProperties(question, value), {
        label: props.label,
        title: props.title,
        placeholder: props.label,
        value: value == null ? "" : value,
        onChange: function onChange(e) {
            props.onChange(e.target.value);
            if (props.sparql || props.turtle) undefined.hide();
        },
        onFocus: function onFocus(e) {
            if (props.sparql) {
                (function () {
                    var yasqe = _yasguiYasqe2.default.fromTextArea(e.target);
                    yasqe.setValue(value);
                    yasqe.on('change', function () {
                        props.onChange(yasqe.getValue());
                    });
                    _yasguiYasqe2.default.Autocompleters.prefixes.appendPrefixIfNeeded = function (yasqe, completerName) {
                        if (!yasqe.autocompleters.getTrie(completerName)) return; // no prefixed defined. just stop
                        if (!yasqe.options.autocompleters || yasqe.options.autocompleters.indexOf(completerName) === -1) return; //this autocompleter is disabled
                        var cur = yasqe.getCursor();

                        var token = yasqe.getTokenAt(cur);
                        if (tokenTypes[token.type] === "prefixed") {
                            var colonIndex = token.string.indexOf(":");
                            if (colonIndex !== -1) {
                                // check previous token isnt PREFIX, or a '<'(which would mean we are in a uri)
                                //			var firstTokenString = yasqe.getNextNonWsToken(cur.line).string.toUpperCase();
                                var lastNonWsTokenString = yasqe.getPreviousNonWsToken(cur.line, token).string.toUpperCase();
                                var previousToken = yasqe.getTokenAt({
                                    line: cur.line,
                                    ch: token.start
                                }); // needs to be null (beginning of line), or whitespace
                                if (lastNonWsTokenString !== "PREFIX" && (previousToken.type === "ws" || previousToken.type == null)) {
                                    (function () {
                                        // check whether it isnt defined already (saves us from looping
                                        // through the array)
                                        var currentPrefix = token.string.substring(0, colonIndex + 1);
                                        var queryPrefixes = yasqe.getPrefixesFromQuery();
                                        if (queryPrefixes[currentPrefix.slice(0, -1)] == null) {
                                            // ok, so it isnt added yet!
                                            if (props.question[_Constants2.default.HAS_DECLARED_PREFIX] && props.question[_Constants2.default.HAS_DECLARED_PREFIX].filter(function (p) {
                                                return p[_Constants2.default.PREFIX] === currentPrefix.slice(0, -1);
                                            }).length) {
                                                var prefix = props.question[_Constants2.default.HAS_DECLARED_PREFIX].filter(function (p) {
                                                    return p[_Constants2.default.PREFIX] === currentPrefix.slice(0, -1);
                                                });
                                                var px = {};
                                                px[prefix[0][_Constants2.default.PREFIX]] = prefix[0][_Constants2.default.NAMESPACE];
                                                yasqe.addPrefixes(px);
                                            } else {
                                                var completions = yasqe.autocompleters.getTrie(completerName).autoComplete(currentPrefix);
                                                if (completions.length > 0) {
                                                    yasqe.addPrefixes(completions[0]);
                                                }
                                            }
                                        }
                                    })();
                                }
                            }
                        }
                    };
                })();
            } else if (props.turtle) {
                (function () {
                    console.log("TTL");
                    var yate = YATE.fromTextArea(e.target);
                    yate.setValue(value);
                    yate.on('change', function () {
                        props.onChange(yate.getValue());
                    });
                })();
            }
        }
    }));
};

InputAnswer.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    answer: _react2.default.PropTypes.object.isRequired,
    label: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
    onChange: _react2.default.PropTypes.func.isRequired
};

exports.default = InputAnswer;