import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import CheckboxAnswer from './answer/CheckboxAnswer';
import DateTimeAnswer from './answer/DateTimeAnswer';
import InputAnswer from './answer/InputAnswer';
import JsonldUtils from 'jsonld-utils';
import MaskedInputAnswer from './answer/MaskedInputAnswer';
import SelectAnswer from './answer/SelectAnswer';
import FormUtils from '../util/FormUtils';
import Utils from '../util/Utils';
import TypeaheadAnswer from './answer/TypeaheadAnswer';
import * as Constants from '../constants/Constants';
import { FormGenContext } from '../contexts/FormGenContext';
import { ConfigurationContext } from '../contexts/ConfigurationContext';

var Answer = function Answer(props) {
  var formGenContext = React.useContext(FormGenContext);

  var _React$useContext = React.useContext(ConfigurationContext),
      options = _React$useContext.options;

  var onValueChange = function onValueChange(value) {
    var change = _objectSpread({}, props.answer);

    _setValue(change, value);

    props.onChange(props.index, change);
  };

  var _setValue = function _setValue(change, value) {
    if (value === null) {
      change[Constants.HAS_OBJECT_VALUE] = null;
      change[Constants.HAS_DATA_VALUE] = null;
    } else if (props.answer[Constants.HAS_OBJECT_VALUE] || FormUtils.isTypeahead(props.question)) {
      change[Constants.HAS_OBJECT_VALUE] = {
        '@id': value
      };
    } else {
      change[Constants.HAS_DATA_VALUE] = {
        '@value': value
      };
    }
  };

  var _hasOptions = function _hasOptions(item) {
    return item[Constants.HAS_OPTION] && item[Constants.HAS_OPTION].length !== 0;
  };

  var _renderTypeahead = function _renderTypeahead(value, label, title) {
    var queryHash = Utils.getStringHash(FormUtils.getPossibleValuesQuery(props.question));
    var options = formGenContext.getOptions(queryHash) || [];
    return /*#__PURE__*/React.createElement(TypeaheadAnswer, {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      options: options
    });
  };

  var _renderSelect = function _renderSelect(value, label, title) {
    return /*#__PURE__*/React.createElement(SelectAnswer, {
      question: props.question,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderDateTimePicker = function _renderDateTimePicker(value, label, title) {
    return /*#__PURE__*/React.createElement(DateTimeAnswer, {
      question: props.question,
      value: value,
      title: title,
      label: label,
      onChange: onValueChange
    });
  };

  var _renderCheckbox = function _renderCheckbox(value, label, title) {
    return /*#__PURE__*/React.createElement(CheckboxAnswer, {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question
    });
  };

  var _renderMaskedInput = function _renderMaskedInput(value, label, title) {
    return /*#__PURE__*/React.createElement(MaskedInputAnswer, {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question,
      answer: props.answer
    });
    return null;
  };

  var _renderRegularInput = function _renderRegularInput(value, label, title) {
    return /*#__PURE__*/React.createElement(InputAnswer, {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderSparqlInput = function _renderSparqlInput(value, label, title) {
    return /*#__PURE__*/React.createElement(InputAnswer, {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      sparql: true
    });
  };

  var _renderTurtleInput = function _renderTurtleInput(value, label, title) {
    return /*#__PURE__*/React.createElement(InputAnswer, {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      turtle: true
    });
  };

  var question = props.question;
  var value = FormUtils.resolveValue(props.answer);
  var label = JsonldUtils.getLocalized(question[JsonldUtils.RDFS_LABEL], options.intl);
  var title = JsonldUtils.getLocalized(question[JsonldUtils.RDFS_COMMENT], options.intl);
  var component;

  if (FormUtils.isTypeahead(question)) {
    component = _renderTypeahead(value, label, title);
  } else if (_hasOptions(question)) {
    component = _renderSelect(value, label, title);
  } else if (FormUtils.isCalendar(question)) {
    component = _renderDateTimePicker(value, label, title);
  } else if (FormUtils.isCheckbox(question)) {
    component = _renderCheckbox(value, label, title);
  } else if (FormUtils.isMaskedInput(question)) {
    component = _renderMaskedInput(value, label, title);
  } else if (FormUtils.isSparqlInput(question)) {
    component = _renderSparqlInput(value, label, title);
  } else if (FormUtils.isTurtleInput(question)) {
    component = _renderTurtleInput(value, label, title);
  } else {
    component = _renderRegularInput(value, label, title);
  }

  return component;
};

Answer.propTypes = {
  answer: PropTypes.object.isRequired,
  question: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
  index: PropTypes.number
};
export default Answer;