import "core-js/modules/es.array.map";
import "core-js/modules/es.array.sort";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PropTypes from 'prop-types';
import { ListGroup, ListGroupItem, OverlayTrigger, Popover } from 'react-bootstrap';
import * as Constants from '../constants/Constants';

var PrefixIcon = /*#__PURE__*/function (_React$Component) {
  _inherits(PrefixIcon, _React$Component);

  var _super = _createSuper(PrefixIcon);

  function PrefixIcon(props) {
    var _this;

    _classCallCheck(this, PrefixIcon);

    _this = _super.call(this, props);
    _this.state = {
      show: props.show,
      prefixes: props.prefixes
    };
    return _this;
  }

  _createClass(PrefixIcon, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var p = /*#__PURE__*/React.createElement(Popover, {
        id: "prefixes",
        title: "Prefixes"
      }, /*#__PURE__*/React.createElement(ListGroup, null, this.state.prefixes.sort(function (l, r) {
        var res = l[Constants.PREFIX] < r[Constants.PREFIX];
        if (res) return -1;
        return 1;
      }).map(function (p) {
        return /*#__PURE__*/React.createElement(ListGroupItem, {
          key: p[Constants.PREFIX]
        }, /*#__PURE__*/React.createElement("strong", null, p[Constants.PREFIX]), ": ", p[Constants.NAMESPACE]);
      })));
      return /*#__PURE__*/React.createElement(OverlayTrigger, {
        trigger: "click",
        placement: "right",
        overlay: p
      }, /*#__PURE__*/React.createElement("span", {
        className: this.props.iconClass,
        onClick: function onClick() {
          return _this2.setState({
            show: !_this2.state.show
          });
        }
      }, this.props.children));
    }
  }]);

  return PrefixIcon;
}(React.Component);

PrefixIcon.propTypes = {
  prefixes: PropTypes.array.isRequired,
  children: PropTypes.element.isRequired,
  iconClass: PropTypes.string,
  show: PropTypes.bool
};
PrefixIcon.defaultProps = {
  iconClass: '',
  show: false
};
export default PrefixIcon;