import "core-js/modules/es.number.constructor";
import React, { useContext } from 'react';
import DatePicker from 'react-datepicker';
import { FormGroup, Form } from 'react-bootstrap';
import PropTypes from 'prop-types';
import { format } from 'date-fns';
import Utils from '../../util/Utils';
import FormUtils from '../../util/FormUtils';
import * as Constants from '../../constants/Constants';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';
import 'react-datepicker/dist/react-datepicker.css';

var DateTimeAnswer = function DateTimeAnswer(props) {
  var _useContext = useContext(ConfigurationContext),
      componentsOptions = _useContext.componentsOptions;

  var dateFormat = Utils.resolveDateTimeFormat(props.question, props.value, componentsOptions.dateTimeAnswer);
  var isDate = FormUtils.isDate(props.question);
  var isTime = FormUtils.isTime(props.question); // workaround because it is not possible to construct Date only with time

  var value;

  if (isTime && props.value) {
    value = new Date("0 ".concat(props.value));
  } else {
    value = props.value ? new Date(props.value) : null;
  } // DatePicker does not know dateFormat "x", translate to datetime


  var datePickerFormat = dateFormat === 'x' ? componentsOptions.dateTimeAnswer.dateTimeFormat : dateFormat;

  var onChange = function onChange(date) {
    if (dateFormat === Constants.DATETIME_NUMBER_FORMAT) {
      props.onChange(Number(date));
    } else {
      props.onChange(format(date, dateFormat));
    }
  };

  return /*#__PURE__*/React.createElement(FormGroup, {
    size: "small"
  }, /*#__PURE__*/React.createElement(Form.Label, null, props.label), /*#__PURE__*/React.createElement(DatePicker, {
    selected: value,
    placeholderText: datePickerFormat.toUpperCase(),
    onChange: onChange,
    showTimeSelect: !isDate,
    showTimeSelectOnly: isTime,
    timeFormat: "HH:mm",
    timeIntervals: 1,
    timeCaption: "Time",
    dateFormat: datePickerFormat,
    className: "form-control",
    disabled: componentsOptions.readOnly || FormUtils.isDisabled(props.question)
  }));
};

DateTimeAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  onChange: PropTypes.func.isRequired
};
export default DateTimeAnswer;