import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.array.index-of";
import "core-js/modules/es.array.slice";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.get-own-property-names";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";

var _this = this;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useContext } from 'react';
import JsonLdUtils from 'jsonld-utils';
import PropTypes from 'prop-types';
import * as Constants from '../../constants/Constants';
import FormUtils from '../../util/FormUtils';
import YASQE from 'yasgui-yasqe';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';
var NUMERIC_DATATYPES = [Constants.XSD.INT, Constants.XSD.INTEGER, Constants.XSD.NON_NEGATIVE_INTEGER, Constants.XSD.NON_POSITIVE_INTEGER, Constants.XSD.NEGATIVE_INTEGER, Constants.XSD.POSITIVE_INTEGER];
var DECLARED_PREFIXES = 'http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix';
var NUMBER_RULES = {};
NUMBER_RULES[Constants.XSD.NON_NEGATIVE_INTEGER] = {
  min: 0
};
NUMBER_RULES[Constants.XSD.NON_POSITIVE_INTEGER] = {
  max: 0
};
NUMBER_RULES[Constants.XSD.NEGATIVE_INTEGER] = {
  max: -1
};
NUMBER_RULES[Constants.XSD.POSITIVE_INTEGER] = {
  min: 1
};
var tokenTypes = {
  'string-2': 'prefixed',
  atom: 'var'
};

var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _classCallCheck(this, InputPropertiesResolver);
  }

  _createClass(InputPropertiesResolver, null, [{
    key: "_resolveInputType",
    value: function _resolveInputType(question, value) {
      if (FormUtils.isSparqlInput(question) || FormUtils.isTurtleInput(question) || FormUtils.isTextarea(question, value)) {
        return 'textarea';
      } else if (InputPropertiesResolver._isNumeric(question)) {
        return 'number';
      }

      return 'text';
    }
  }, {
    key: "_isNumeric",
    value: function _isNumeric(question) {
      for (var i = 0, len = NUMERIC_DATATYPES.length; i < len; i++) {
        if (JsonLdUtils.hasValue(question, Constants.HAS_DATATYPE, NUMERIC_DATATYPES[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "resolveInputProperties",
    value: function resolveInputProperties(question, value, componentsOptions) {
      var props = {};
      props.type = InputPropertiesResolver._resolveInputType(question, value);

      switch (props['type']) {
        case 'textarea':
          props.rows = 5;
          break;

        case 'number':
          props = _objectSpread(_objectSpread({}, props), InputPropertiesResolver._resolveNumberRestrictions(question));
          break;

        default:
          break;
      }

      props.disabled = componentsOptions.readOnly || FormUtils.isDisabled(question);

      if (question[Constants.HAS_VALID_ANSWER] === false) {
        props.validation = 'error';
        props.help = question[Constants.HAS_VALIDATION_MESSAGE];
      }

      return props;
    }
  }, {
    key: "_resolveNumberRestrictions",
    value: function _resolveNumberRestrictions(question) {
      var restriction = {};
      Object.getOwnPropertyNames(NUMBER_RULES).forEach(function (key) {
        if (JsonLdUtils.hasValue(question, Constants.HAS_DATATYPE, key)) {
          restriction = _objectSpread(_objectSpread({}, restriction), NUMBER_RULES[key]);
        }
      });

      if (question[Constants.XSD.MIN_INCLUSIVE] !== undefined) {
        restriction['min'] = question[Constants.XSD.MIN_INCLUSIVE];
      }

      if (question[Constants.XSD.MIN_EXCLUSIVE] !== undefined) {
        restriction['min'] = question[Constants.XSD.MIN_EXCLUSIVE] + 1;
      }

      if (question[Constants.XSD.MAX_EXCLUSIVE] !== undefined) {
        restriction['max'] = question[Constants.XSD.MAX_EXCLUSIVE] - 1;
      }

      if (question[Constants.XSD.MAX_INCLUSIVE] !== undefined) {
        restriction['max'] = question[Constants.XSD.MAX_INCLUSIVE];
      }

      return restriction;
    }
  }]);

  return InputPropertiesResolver;
}();

var InputAnswer = function InputAnswer(props) {
  var _useContext = useContext(ConfigurationContext),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var answer = props.answer;
  var value = props.value; // When the value is an object_value, but the layout does not specify neither typeahead nor select,
  // show at least the value's label

  if (answer[Constants.HAS_OBJECT_VALUE] && answer[Constants.HAS_OBJECT_VALUE][JsonLdUtils.RDFS_LABEL]) {
    value = JsonLdUtils.getJsonAttValue(answer[Constants.HAS_OBJECT_VALUE], JsonLdUtils.RDFS_LABEL);
  }

  return React.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveInputProperties(question, value, componentsOptions)), {}, {
    label: props.label,
    title: props.title,
    value: value == null ? '' : value,
    onChange: function onChange(e) {
      props.onChange(e.target.value);
      if (props.sparql || props.turtle) _this.hide();
    },
    onFocus: function onFocus(e) {
      if (props.sparql) {
        var yasqe = YASQE.fromTextArea(e.target);
        yasqe.setValue(value);
        yasqe.on('change', function () {
          props.onChange(yasqe.getValue());
        });

        YASQE.Autocompleters.prefixes.appendPrefixIfNeeded = function (yasqe, completerName) {
          if (!yasqe.autocompleters.getTrie(completerName)) return; // no prefixed defined. just stop

          if (!yasqe.options.autocompleters || yasqe.options.autocompleters.indexOf(completerName) === -1) return; //this autocompleter is disabled

          var cur = yasqe.getCursor();
          var token = yasqe.getTokenAt(cur);

          if (tokenTypes[token.type] === 'prefixed') {
            var colonIndex = token.string.indexOf(':');

            if (colonIndex !== -1) {
              // check previous token isnt PREFIX, or a '<'(which would mean we are in a uri)
              //			const firstTokenString = yasqe.getNextNonWsToken(cur.line).string.toUpperCase();
              var lastNonWsTokenString = yasqe.getPreviousNonWsToken(cur.line, token).string.toUpperCase();
              var previousToken = yasqe.getTokenAt({
                line: cur.line,
                ch: token.start
              }); // needs to be null (beginning of line), or whitespace

              if (lastNonWsTokenString !== 'PREFIX' && (previousToken.type === 'ws' || previousToken.type == null)) {
                // check whether it isnt defined already (saves us from looping
                // through the array)
                var currentPrefix = token.string.substring(0, colonIndex + 1);
                var queryPrefixes = yasqe.getPrefixesFromQuery();

                if (queryPrefixes[currentPrefix.slice(0, -1)] == null) {
                  // ok, so it isnt added yet!
                  if (props.question[Constants.HAS_DECLARED_PREFIX] && props.question[Constants.HAS_DECLARED_PREFIX].filter(function (p) {
                    return p[Constants.PREFIX] === currentPrefix.slice(0, -1);
                  }).length) {
                    var prefix = props.question[Constants.HAS_DECLARED_PREFIX].filter(function (p) {
                      return p[Constants.PREFIX] === currentPrefix.slice(0, -1);
                    });
                    var px = {};
                    px[prefix[0][Constants.PREFIX]] = prefix[0][Constants.NAMESPACE];
                    yasqe.addPrefixes(px);
                  } else {
                    var completions = yasqe.autocompleters.getTrie(completerName).autoComplete(currentPrefix);

                    if (completions.length > 0) {
                      yasqe.addPrefixes(completions[0]);
                    }
                  }
                }
              }
            }
          }
        };
      } else if (props.turtle) {
        console.log('TTL');
        var yate = YATE.fromTextArea(e.target);
        yate.setValue(value);
        yate.on('change', function () {
          props.onChange(yate.getValue());
        });
      }
    }
  }));
};

InputAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  answer: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  onChange: PropTypes.func.isRequired
};
export default InputAnswer;