import "core-js/modules/es.symbol";
import "core-js/modules/es.symbol.description";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.array.sort";
import "core-js/modules/es.function.name";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import "regenerator-runtime/runtime";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useState, useEffect, useContext } from 'react';
import JsonLdUtils from 'jsonld-utils';
import Select, { components } from 'react-select';
import PropTypes from 'prop-types';
import * as Constants from '../../constants/Constants';
import FormUtils from '../../util/FormUtils';
import Utils from '../../util/Utils';
import JsonLdObjectUtils from '../../util/JsonLdObjectUtils';
import Logger from '../../util/Logger';
import { FormGroup, Form } from 'react-bootstrap';
import { FormGenContext } from '../../contexts/FormGenContext';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var processTypeaheadOptions = function processTypeaheadOptions(options, intl) {
  if (!options) {
    return [];
  } // sort by label


  options.sort(JsonLdObjectUtils.getCompareLocalizedLabelFunction(intl)); // sort by property

  JsonLdObjectUtils.orderPreservingToplogicalSort(options, Constants.HAS_PRECEDING_VALUE);
  return JsonLdUtils.processTypeaheadOptions(options, intl);
};

var TypeaheadAnswer = function TypeaheadAnswer(props) {
  var queryHash = Utils.getStringHash(FormUtils.getPossibleValuesQuery(props.question));
  var formGenContext = useContext(FormGenContext);
  var configurationContext = useContext(ConfigurationContext);
  var intl = configurationContext.options.intl;

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      isLoading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = useState(processTypeaheadOptions(props.options, intl)),
      _useState4 = _slicedToArray(_useState3, 2),
      options = _useState4[0],
      setOptions = _useState4[1];

  useEffect(function () {
    var isCancelled = false;
    var question = props.question;

    function loadFormOptions() {
      return _loadFormOptions.apply(this, arguments);
    }

    function _loadFormOptions() {
      _loadFormOptions = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
        var _options;

        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return formGenContext.loadFormOptions(queryHash, FormUtils.getPossibleValuesQuery(question));

              case 3:
                _options = _context.sent;

                if (!isCancelled) {
                  setLoading(false);
                  setOptions(processTypeaheadOptions(_options, intl));
                }

                _context.next = 10;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](0);
                Logger.error("An error has occurred during loadFormOptions for query hash: ".concat(queryHash));

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 7]]);
      }));
      return _loadFormOptions.apply(this, arguments);
    }

    if (!question[Constants.HAS_OPTION] && FormUtils.getPossibleValuesQuery(question)) {
      loadFormOptions();
    } else {
      setLoading(false);
      setOptions(processTypeaheadOptions(question[Constants.HAS_OPTION], intl));
    }

    return function () {
      isCancelled = true;
    };
  }, []);

  var onOptionSelected = function onOptionSelected(option) {
    props.onChange(option ? option.id : null);
  };

  var Option = components.Option;

  var DescriptionOption = function DescriptionOption(props) {
    var innerProps = _objectSpread(_objectSpread({}, props.innerProps), {}, {
      title: props.data.description
    });

    return /*#__PURE__*/React.createElement(Option, _extends({}, props, {
      title: props.data.description,
      innerProps: innerProps
    }));
  };

  return /*#__PURE__*/React.createElement(FormGroup, {
    size: "small"
  }, /*#__PURE__*/React.createElement(Form.Label, null, props.label), /*#__PURE__*/React.createElement(Select, {
    options: options,
    isSearchable: true,
    isLoading: isLoading,
    isClearable: true,
    isDisabled: isLoading || configurationContext.componentsOptions.readOnly || FormUtils.isDisabled(props.question),
    value: options.filter(function (option) {
      return option.id === props.value;
    }),
    placeholder: '',
    getOptionLabel: function getOptionLabel(option) {
      return option.name;
    },
    getOptionValue: function getOptionValue(option) {
      return option.id;
    },
    onChange: onOptionSelected,
    components: {
      Option: DescriptionOption
    }
  }));
};

TypeaheadAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  answer: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired
};
export default TypeaheadAnswer;