import "core-js/modules/es.array.map";
import React, { useContext } from 'react';
import { Nav, NavItem, NavLink, Card } from 'react-bootstrap';
import PropTypes from 'prop-types';
import JsonLdUtils from 'jsonld-utils';
import FormUtils from '../../util/FormUtils';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var HorizontalWizardNav = function HorizontalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = useContext(ConfigurationContext),
      options = _useContext.options;

  return /*#__PURE__*/React.createElement(Card.Header, null, /*#__PURE__*/React.createElement(Nav, {
    variant: "tabs",
    activeKey: currentStep,
    onSelect: function onSelect(key) {
      return onNavigate(parseInt(key));
    }
  }, steps.map(function (step, index) {
    return /*#__PURE__*/React.createElement(NavItem, {
      key: 'nav' + index,
      id: 'wizard-nav-' + index
    }, /*#__PURE__*/React.createElement(NavLink, {
      eventKey: index,
      active: index === currentStep,
      disabled: !FormUtils.isRelevant(step)
    }, JsonLdUtils.getLocalized(step[JsonLdUtils.RDFS_LABEL], options.intl)));
  })));
};

HorizontalWizardNav.propTypes = {
  currentStep: PropTypes.number.isRequired,
  steps: PropTypes.array.isRequired,
  onNavigate: PropTypes.func.isRequired
};
export default HorizontalWizardNav;