import "core-js/modules/es.array.splice";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

var _this = this;

import React from 'react';
import PropTypes from 'prop-types';
import { Card } from 'react-bootstrap';
import WizardStep from './WizardStep';
import HorizontalWizardNav from './HorizontalWizardNav';
import VerticalWizardNav from './VerticalWizardNav';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';
import WizardWindow from './WizardWindow';
import { WizardContext } from '../../contexts/WizardContext';

var Wizard = function Wizard(props) {
  var _React$useState = React.useState(props.start || 0),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      currentStep = _React$useState2[0],
      setCurrentStep = _React$useState2[1];

  var wizardContext = React.useContext(WizardContext);
  var configurationContext = React.useContext(ConfigurationContext);

  var onAdvance = function onAdvance() {
    if (currentStep !== wizardContext.getStepData().length - 1) {
      wizardContext.getStepData()[currentStep + 1].visited = true;
      setCurrentStep(function (prevCurrentStep) {
        return prevCurrentStep + 1;
      });
    }
  };

  var onRetreat = function onRetreat() {
    if (currentStep === 0) {
      return;
    }

    setCurrentStep(function (prevCurrentStep) {
      return prevCurrentStep - 1;
    });
  };

  var onFinish = function onFinish(errCallback) {
    var data = {
      data: _this.context.getData(),
      stepData: _this.context.getStepData()
    };

    _this.context.reset();

    _this.props.onFinish(data, _this.props.onClose, errCallback);
  };
  /**
   * Insert the specified step after the current one.
   * @param step The step to insert
   */


  var onInsertStepAfterCurrent = function onInsertStepAfterCurrent(step) {
    configurationContext.getStepData().splice(currentStep + 1, 0, step);
    configurationContext.insertStep(currentStep + 1, step);
  };
  /**
   * Adds the specified step to the end of this wizard.
   * @param step The step to add
   */


  var onAddStep = function onAddStep(step) {
    wizardContext.getStepData().push(step);
    wizardContext.insertStep(wizardContext.getStepData().length - 1, step);
  };

  var onRemoveStep = function onRemoveStep(stepId) {
    var stepData = wizardContext.getStepData();

    for (var i = 0; i < stepData.length; i++) {
      if (stepData[i].id === stepId) {
        wizardContext.getStepData().splice(i, 1);
        wizardContext.removeStep(i);

        if (i === currentStep && i !== 0) {
          setCurrentStep(function (prevCurrentStep) {
            return prevCurrentStep - 1;
          });
        }

        break;
      }
    }
  };

  var navigate = function navigate(stepIndex) {
    if (stepIndex === currentStep || stepIndex >= wizardContext.getStepData().length) {
      return;
    } // Can we jump forward?


    if (stepIndex > currentStep && !wizardContext.getStepData()[stepIndex].visited && !props.enableForwardSkip) {
      return;
    }

    setCurrentStep(stepIndex);
  };

  var renderNav = function renderNav() {
    if (wizardContext.getStepData().length <= 1) {
      return null;
    }

    return configurationContext.options.horizontalWizardNav ? /*#__PURE__*/React.createElement(HorizontalWizardNav, {
      currentStep: currentStep,
      steps: wizardContext.getStepData(),
      onNavigate: navigate
    }) : /*#__PURE__*/React.createElement(VerticalWizardNav, {
      currentStep: currentStep,
      steps: wizardContext.getStepData(),
      onNavigate: navigate
    });
  };

  var renderWizard = function renderWizard() {
    var isHorizontal = configurationContext.options.horizontalWizardNav;
    var cardClassname = isHorizontal ? '' : 'flex-row p-2';
    var containerClassname = isHorizontal ? 'card-body' : 'col-10 p-0';
    return /*#__PURE__*/React.createElement(Card, {
      className: cardClassname
    }, renderNav(), /*#__PURE__*/React.createElement("div", {
      className: containerClassname
    }, initComponent()));
  };

  var initComponent = function initComponent() {
    var stepData = wizardContext.getStepData();

    if (stepData.length === 0) {
      return /*#__PURE__*/React.createElement("div", {
        className: "font-italic"
      }, "There are no steps in this wizard.");
    }

    var step = stepData[currentStep];
    return /*#__PURE__*/React.createElement(WizardStep, {
      key: 'step' + currentStep,
      step: step,
      onFinish: onFinish,
      onAdvance: onAdvance,
      onRetreat: onRetreat,
      onInsertStepAfterCurrent: onInsertStepAfterCurrent,
      onAddStep: onAddStep,
      onRemoveStep: onRemoveStep,
      stepIndex: currentStep,
      isFirstStep: currentStep === 0,
      isLastStep: currentStep === wizardContext.getStepData().length - 1
    });
  };

  if (configurationContext.options.modalView) {
    return /*#__PURE__*/React.createElement(WizardWindow, null, renderWizard());
  }

  return renderWizard();
};

Wizard.propTypes = {
  start: PropTypes.number,
  onFinish: PropTypes.func,
  onClose: PropTypes.func,
  enableForwardSkip: PropTypes.bool // Whether to allow forward step skipping

};
export default Wizard;