import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'react-bootstrap';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';
var WizardWindow = React.forwardRef(function (props, ref) {
  var _React$useContext = React.useContext(ConfigurationContext),
      options = _React$useContext.options;

  return /*#__PURE__*/React.createElement(Modal, _extends({
    size: "xl",
    animation: true
  }, options.modalProps), /*#__PURE__*/React.createElement(Modal.Header, {
    closeButton: true
  }, /*#__PURE__*/React.createElement(Modal.Title, null, options.modalProps.title)), /*#__PURE__*/React.createElement(Modal.Body, {
    className: "overflow-hidden p-0"
  }, props.children));
});
WizardWindow.propTypes = {
  children: PropTypes.element.isRequired
};
export default WizardWindow;