import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useMemo } from 'react';
import PropTypes from 'prop-types';
var ConfigurationContext = React.createContext({});
var defaultProps = {
  components: {
    inputComponent: require('../components/DefaultInput').default
  },
  componentsOptions: {
    dateTimeAnswer: {
      dateFormat: 'yyyy-MM-dd',
      timeFormat: 'HH:mm:ss',
      dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    readOnly: false
  },
  options: {
    intl: {
      locale: 'en'
    },
    i18n: {
      'wizard.next': 'Next',
      'wizard.previous': 'Previous'
    },
    modalView: false,
    modalProps: {},
    horizontalWizardNav: true
  }
};

var ConfigurationContextProvider = function ConfigurationContextProvider(_ref) {
  var children = _ref.children,
      props = _objectWithoutProperties(_ref, ["children"]);

  var values = useMemo(function () {
    return {
      inputComponent: props.components && props.components.inputComponent || defaultProps.components.inputComponent,
      componentsOptions: _objectSpread(_objectSpread({}, defaultProps.componentsOptions), props.componentsOptions),
      options: _objectSpread(_objectSpread({}, defaultProps.options), props.options)
    };
  }, []);
  return /*#__PURE__*/React.createElement(ConfigurationContext.Provider, {
    value: values
  }, children);
};

ConfigurationContextProvider.propTypes = {
  children: PropTypes.element.isRequired,
  components: PropTypes.object,
  componentsOptions: PropTypes.object,
  options: PropTypes.object
};
export { ConfigurationContext, ConfigurationContextProvider };