import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.array.splice";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useMemo, useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import FormUtils from '../util/FormUtils';
var INITIAL_DATA = {};
var INITIAL_STEP_DATA = [];
var WizardContext = React.createContext({});

var WizardContextProvider = function WizardContextProvider(props) {
  var _useState = useState(props.data || INITIAL_DATA),
      _useState2 = _slicedToArray(_useState, 2),
      data = _useState2[0],
      setData = _useState2[1];

  var _useState3 = useState(props.steps || INITIAL_STEP_DATA),
      _useState4 = _slicedToArray(_useState3, 2),
      stepData = _useState4[0],
      setStepData = _useState4[1];

  useEffect(function () {
    if (props.isFormValid) {
      var isValid = FormUtils.isValid(data);
      props.isFormValid(isValid);
    }
  }, []);

  var updateData = function updateData(update) {
    if (!update) return;
    setData(_objectSpread(_objectSpread({}, data), update));
  };

  var updateStepData = function updateStepData(index, update) {
    if (!update || index < 0 || index >= stepData.length) return;

    var newStepData = _toConsumableArray(stepData);

    newStepData[index] = _objectSpread(_objectSpread({}, newStepData[index]), update);
    setStepData(newStepData);

    if (props.isFormValid) {
      var isValid = FormUtils.isValid(data);
      props.isFormValid(isValid);
    }
  };

  var insertStep = function insertStep(index, update) {
    var newStepData = _toConsumableArray(stepData);

    newStepData.splice(index, 0, update || {});
    setStepData(newStepData);
  };

  var removeStep = function removeStep(index) {
    var newStepData = _toConsumableArray(stepData);

    newStepData.splice(index, 1);
    setStepData(newStepData);
  };

  var reset = function reset() {
    setData(INITIAL_DATA);
    setStepData(INITIAL_STEP_DATA);
  };

  var getData = function getData() {
    return data;
  };

  var getStepData = function getStepData(index) {
    return index === null || index === undefined ? stepData : stepData[index];
  };

  var values = useMemo(function () {
    return {
      updateData: updateData,
      updateStepData: updateStepData,
      insertStep: insertStep,
      removeStep: removeStep,
      reset: reset,
      getData: getData,
      getStepData: getStepData
    };
  }, [getStepData, getData]);
  return /*#__PURE__*/React.createElement(WizardContext.Provider, _extends({
    value: values
  }, props), props.children);
};

WizardContextProvider.propTypes = {
  children: PropTypes.element.isRequired,
  data: PropTypes.object.isRequired,
  steps: PropTypes.array.isRequired,
  isFormValid: PropTypes.func
};
export { WizardContext, WizardContextProvider };