'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _Mask = require('../components/Mask');

var _Mask2 = _interopRequireDefault(_Mask);

var _getDisplayName = require('../util/getDisplayName');

var _getDisplayName2 = _interopRequireDefault(_getDisplayName);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

/**
 * Generic loading mask displaying HOC, which can be used to wrap arbitrary components expected to receive loading
 * property.
 * @param Component The component to wrap
 * @param options Configuration for the generated wrapper
 * @constructor
 */
var withLoading = function withLoading(Component, options) {
    var Wrapped = function Wrapped(options) {
        var tag = options.tag ? options.tag : 'div';
        var className = (0, _classnames2.default)(options.containerClass, 'relative');

        return React.createElement(tag, { className: className }, loading && React.createElement(_Mask2.default, { text: loadingMsg, classes: options.maskClass }), React.createElement(Component, props));
    };
    Wrapped.displayName = "LoadingWrapper(" + (0, _getDisplayName2.default)(Component) + ")";
    return Wrapped;
};

exports.default = withLoading;