import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import * as Constants from '../constants/Constants';

var DefaultFormGenerator = /*#__PURE__*/function () {
  function DefaultFormGenerator() {
    _classCallCheck(this, DefaultFormGenerator);
  }

  _createClass(DefaultFormGenerator, null, [{
    key: "generateForm",

    /**
     * Generates default form for the wizard framework.
     *
     * The form consists of a single step, which contains one text area for the description.
     *
     * @param rootQuestion Optional, contains root question with data for the default form template
     */
    value: function generateForm(rootQuestion) {
      var formTemplate = require('./defaultForm'); // Deep copy of the form template to prevent modifications


      formTemplate = JSON.parse(JSON.stringify(formTemplate));

      if (!rootQuestion) {
        return formTemplate;
      }

      var form = formTemplate['@graph'][0];
      var formStep = form[Constants.HAS_SUBQUESTION][0];
      var stepQuestion = formStep[Constants.HAS_SUBQUESTION][0];
      var questionAnswer = stepQuestion[Constants.HAS_ANSWER];
      var step = rootQuestion.subQuestions ? rootQuestion.subQuestions[0] : null;
      form['@id'] = rootQuestion.uri;

      if (!step) {
        return formTemplate;
      }

      formStep['@id'] = step.uri;
      var question = step.subQuestions ? step.subQuestions[0] : null;

      if (!question) {
        return formTemplate;
      }

      stepQuestion['@id'] = question.uri;
      var answer = question.answers ? question.answers[0] : {};

      if (answer) {
        questionAnswer['@id'] = answer.uri;
        questionAnswer[Constants.HAS_DATA_VALUE] = answer.textValue;
      }

      return formTemplate;
    }
  }]);

  return DefaultFormGenerator;
}();

export { DefaultFormGenerator as default };