import "core-js/modules/es.symbol";
import "core-js/modules/es.symbol.description";
import "core-js/modules/es.symbol.iterator";
import "core-js/modules/es.array.from";
import "core-js/modules/es.array.iterator";
import "core-js/modules/es.array.slice";
import "core-js/modules/es.function.name";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.regexp.to-string";
import "core-js/modules/es.string.iterator";
import "core-js/modules/web.dom-collections.iterator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

import JsonLdUtils from 'jsonld-utils';
import jsonld from 'jsonld';
import * as Constants from '../constants/Constants';
import Utils from './Utils';
import JsonLdObjectMap from './JsonLdObjectMap';
import JsonLdObjectUtils from './JsonLdObjectUtils';

var FormUtils = /*#__PURE__*/function () {
  function FormUtils() {
    _classCallCheck(this, FormUtils);
  }

  _createClass(FormUtils, null, [{
    key: "isForm",
    value: function isForm(structure) {
      return JsonLdUtils.hasValue(structure, Constants.LAYOUT_CLASS, Constants.LAYOUT.FORM);
    }
  }, {
    key: "isWizardStep",
    value: function isWizardStep(structure) {
      return JsonLdUtils.hasValue(structure, Constants.LAYOUT_CLASS, Constants.LAYOUT.WIZARD_STEP);
    }
  }, {
    key: "isSection",
    value: function isSection(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.QUESTION_SECTION);
    }
  }, {
    key: "isAnswerable",
    value: function isAnswerable(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.ANSWERABLE);
    }
  }, {
    key: "isTypeahead",
    value: function isTypeahead(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.QUESTION_TYPEAHEAD);
    }
  }, {
    key: "getPossibleValuesQuery",
    value: function getPossibleValuesQuery(question) {
      return JsonLdUtils.getJsonAttValue(question, Constants.HAS_OPTIONS_QUERY);
    }
  }, {
    key: "isDisabled",
    value: function isDisabled(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.DISABLED);
    }
  }, {
    key: "isHidden",
    value: function isHidden(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.HIDDEN);
    }
  }, {
    key: "isTextarea",
    value: function isTextarea(question, answerValue) {
      return answerValue && answerValue.length > Constants.INPUT_LENGTH_THRESHOLD && !FormUtils.isTypeahead(question) || JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.TEXTAREA);
    }
  }, {
    key: "isCalendar",
    value: function isCalendar(question) {
      return FormUtils.isDate(question) || FormUtils.isTime(question) || FormUtils.isDateTime(question);
    }
  }, {
    key: "isDate",
    value: function isDate(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.DATE);
    }
  }, {
    key: "isTime",
    value: function isTime(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.TIME);
    }
  }, {
    key: "isDateTime",
    value: function isDateTime(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.DATETIME);
    }
  }, {
    key: "isCheckbox",
    value: function isCheckbox(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.CHECKBOX);
    }
  }, {
    key: "isMaskedInput",
    value: function isMaskedInput(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.MASKED_INPUT);
    }
  }, {
    key: "isSparqlInput",
    value: function isSparqlInput(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.SPARQL);
    }
  }, {
    key: "isTurtleInput",
    value: function isTurtleInput(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.TURTLE);
    }
  }, {
    key: "isCollapsed",
    value: function isCollapsed(question) {
      return JsonLdUtils.hasValue(question, Constants.LAYOUT_CLASS, Constants.LAYOUT.COLLAPSED);
    }
  }, {
    key: "resolveValue",
    value: function resolveValue(answer) {
      if (!answer) {
        return null;
      }

      if (answer[Constants.HAS_OBJECT_VALUE]) {
        return answer[Constants.HAS_OBJECT_VALUE]['@id'];
      } else {
        return JsonLdUtils.getJsonAttValue(answer, Constants.HAS_DATA_VALUE);
      }
    }
  }, {
    key: "resolveValueObject",
    value: function resolveValueObject(answer) {
      if (!answer) {
        return null;
      }

      if (answer[Constants.HAS_OBJECT_VALUE]) {
        return Utils.asArray(answer[Constants.HAS_OBJECT_VALUE])[0];
      }

      if (answer[Constants.HAS_DATA_VALUE]) {
        return Utils.asArray(answer[Constants.HAS_DATA_VALUE])[0];
      }

      return null;
    }
  }, {
    key: "isRelevant",
    value: function isRelevant(question) {
      if (!question[Constants.IS_RELEVANT_IF]) {
        return true;
      }

      var _iterator = _createForOfIteratorHelper(Utils.asArray(question[Constants.IS_RELEVANT_IF])),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var cond = _step.value;

          if (!FormUtils.testCondition(cond)) {
            return false;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return true;
    }
  }, {
    key: "hasValidationLogic",
    value: function hasValidationLogic(question) {
      if (question[Constants.REQUIRES_ANSWER_VALUE]) {
        return true;
      }

      if (question[Constants.REQUIRES_ANSWER]) {
        return true;
      }

      if (question[Constants.REQUIRES_ANSWER_IF]) {
        return true;
      }

      return false;
    }
  }, {
    key: "isValid",
    value: function isValid(question) {
      if (question[Constants.HAS_VALID_ANSWER] === false) {
        return false;
      }

      var _iterator2 = _createForOfIteratorHelper(Utils.asArray(question[Constants.HAS_SUBQUESTION])),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var subQ = _step2.value;

          if (this.isValid(subQ) === false) {
            return false;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return true;
    }
  }, {
    key: "testCondition",
    value: function testCondition(condition) {
      var acceptedValidationsValues = condition[Constants.ACCEPTS_VALIDATION_VALUE];
      var acceptedAnswerValues = condition[Constants.ACCEPTS_ANSWER_VALUE];
      var testedQuestions = condition[Constants.HAS_TESTED_QUESTION];
      var question;

      if (acceptedValidationsValues && acceptedAnswerValues) {
        console.warn('Support for validation and requirement constraints at same time is not implemented !');
      } // valid answers


      if (acceptedValidationsValues && testedQuestions) {
        var arr = Utils.asArray(acceptedValidationsValues);

        if (arr.length !== 1 || arr[0] !== true && arr[0] !== 'true') {
          console.warn('Validation values other than "true" are not implemented !');
        }

        var _iterator3 = _createForOfIteratorHelper(Utils.asArray(testedQuestions)),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var q = _step3.value;
            question = JsonLdObjectMap.getObject(q['@id']);

            if (question === undefined) {
              console.warn('Questions is not loaded in an object map.');
              return true;
            }

            if (this.isValid(question) === false) {
              return false;
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        return true;
      } // concrete values


      if (acceptedAnswerValues && testedQuestions) {
        question = JsonLdObjectMap.getObject(testedQuestions['@id']);

        var _iterator4 = _createForOfIteratorHelper(Utils.asArray(acceptedAnswerValues)),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var expValue = _step4.value;

            if (!question) {
              console.warn('Question is not defined.');
              return true;
            }

            if (!question.hasOwnProperty(Constants.HAS_ANSWER)) {
              console.warn('Question does not have answer value defined.');
              return true;
            }

            var answers = jsonld.getValues(question, Constants.HAS_ANSWER);

            if (answers.length === 0) {
              return false;
            }

            var qValue = FormUtils.resolveValueObject(answers[0]);

            if (qValue && expValue && qValue.hasOwnProperty('@value') && expValue.hasOwnProperty('@id') && qValue['@value'] == expValue['@id']) {
              // TODO remove !, this is temporary fix as type-ahead component returns data-value instead of
              // code-value
              return true;
            }

            if (JsonLdObjectUtils.compareValues(qValue, expValue)) {
              return true;
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return false;
    }
  }]);

  return FormUtils;
}();

export { FormUtils as default };