import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import * as Constants from '../constants/Constants';
import FormUtils from './FormUtils';

var Utils = /*#__PURE__*/function () {
  function Utils() {
    _classCallCheck(this, Utils);
  }

  _createClass(Utils, null, [{
    key: "getStringHash",

    /**
     * Calculates a simple hash of the specified string, much like usual Java implementations.
     * @param str The string to compute has for
     * @return {number}
     */
    value: function getStringHash(str) {
      var hash = 0;
      var strlen = str ? str.length : 0;

      if (strlen === 0) {
        return hash;
      }

      for (var i = 0; i < strlen; i++) {
        hash = (hash << 5) - hash + str.charCodeAt(i);
        hash = hash & hash; // Convert to 32bit integer
      }

      return hash;
    }
    /**
     * Resolves which format of date/time/datetime value should be used in the datetime picker.
     * @param question Question with format info
     * @param originalValue Value read from answer, not processed by the rendered component
     * @param options Object with datetime formats
     * @return {*} Format from Configuration
     */

  }, {
    key: "resolveDateTimeFormat",
    value: function resolveDateTimeFormat(question, originalValue, options) {
      if (typeof originalValue === 'number') {
        return Constants.DATETIME_NUMBER_FORMAT;
      }

      if (FormUtils.isDate(question)) {
        return options.dateFormat;
      } else if (FormUtils.isTime(question)) {
        return options.timeFormat;
      }

      return options.dateTimeFormat;
    }
    /**
     * Wraps passed object into new array if it is not array already.
     * @param object_or_array An object or array.
     * @returns {*} New array containing passed object or passed array.
     */

  }, {
    key: "asArray",
    value: function asArray(object_or_array) {
      if (!object_or_array) {
        return [];
      }

      if (object_or_array.constructor === Array) {
        return object_or_array;
      }

      return [object_or_array];
    }
  }]);

  return Utils;
}();

export { Utils as default };