import "core-js/modules/es.number.constructor";
import "core-js/modules/es.number.max-safe-integer";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import ReactDOM from 'react-dom';
import PropTypes from 'prop-types';
import { FormText, FormControl, FormGroup, Form } from 'react-bootstrap';

var DefaultInput = /*#__PURE__*/function (_React$Component) {
  _inherits(DefaultInput, _React$Component);

  var _super = _createSuper(DefaultInput);

  function DefaultInput() {
    _classCallCheck(this, DefaultInput);

    return _super.apply(this, arguments);
  }

  _createClass(DefaultInput, [{
    key: "focus",
    value: function focus() {
      ReactDOM.findDOMNode(this.input).focus();
    }
  }, {
    key: "getInputDOMNode",
    value: function getInputDOMNode() {
      return ReactDOM.findDOMNode(this.input);
    }
  }, {
    key: "render",
    value: function render() {
      switch (this.props.type) {
        case 'radio':
          return this._renderRadio();

        case 'checkbox':
          return this._renderCheckbox();

        case 'select':
          return this._renderSelect();

        case 'textarea':
          return this._renderTextArea();

        default:
          return this._renderInput();
      }
    }
  }, {
    key: "_renderCheckbox",
    value: function _renderCheckbox() {
      var _this = this;

      // TODO change control id to hash of label
      return /*#__PURE__*/React.createElement(Form.Group, {
        size: "small",
        controlId: Math.floor(Math.random() * Number.MAX_SAFE_INTEGER)
      }, /*#__PURE__*/React.createElement(Form.Check, _extends({
        type: "checkbox",
        ref: function ref(c) {
          return _this.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderRadio",
    value: function _renderRadio() {
      var _this2 = this;

      return /*#__PURE__*/React.createElement(FormGroup, {
        size: "small"
      }, /*#__PURE__*/React.createElement(Form.Check, _extends({
        type: "radio",
        ref: function ref(c) {
          return _this2.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderSelect",
    value: function _renderSelect() {
      var _this3 = this;

      // TODO validation
      return /*#__PURE__*/React.createElement(FormGroup, {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/React.createElement(FormControl, _extends({
        as: "select",
        ref: function ref(c) {
          return _this3.input = c;
        }
      }, this.props), this.props.children), this.props.validation && /*#__PURE__*/React.createElement(FormControl.Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderLabel",
    value: function _renderLabel() {
      return this.props.label ? /*#__PURE__*/React.createElement(Form.Label, null, this.props.label) : null;
    }
  }, {
    key: "_renderTextArea",
    value: function _renderTextArea() {
      var _this4 = this;

      // TODO validation
      return /*#__PURE__*/React.createElement(FormGroup, {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/React.createElement(FormControl, _extends({
        as: "textarea",
        style: {
          height: 'auto'
        },
        ref: function ref(c) {
          return _this4.input = c;
        }
      }, this.props)), this.props.validation && /*#__PURE__*/React.createElement(FormControl.Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderHelp",
    value: function _renderHelp() {
      return this.props.help ? /*#__PURE__*/React.createElement(FormText, null, this.props.help) : null;
    }
  }, {
    key: "_renderInput",
    value: function _renderInput() {
      var _this5 = this;

      // TODO validation
      return /*#__PURE__*/React.createElement(FormGroup, {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/React.createElement(FormControl, _extends({
        ref: function ref(c) {
          return _this5.input = c;
        },
        as: "input"
      }, this.props)), this.props.validation && /*#__PURE__*/React.createElement(FormControl.Feedback, null), this._renderHelp());
    }
  }]);

  return DefaultInput;
}(React.Component);

export { DefaultInput as default };
DefaultInput.propTypes = {
  type: PropTypes.string,
  label: PropTypes.string,
  value: PropTypes.any,
  onChange: PropTypes.func,
  help: PropTypes.string,
  validation: PropTypes.oneOf(['success', 'warning', 'error'])
};
DefaultInput.defaultProps = {
  type: 'text'
};