import React from 'react';
import PropTypes from 'prop-types';
import { OverlayTrigger, Tooltip } from 'react-bootstrap';
import { QuestionCircle } from '../styles/icons';

var HelpIcon = function HelpIcon(props) {
  var tooltip = /*#__PURE__*/React.createElement(Tooltip, {
    id: "help-tooltip",
    className: "tooltip-content"
  }, props.text);
  return /*#__PURE__*/React.createElement(OverlayTrigger, {
    placement: "right",
    overlay: tooltip
  }, /*#__PURE__*/React.createElement("span", {
    className: props.iconClassContainer,
    style: {
      position: 'absolute'
    }
  }, /*#__PURE__*/React.createElement(QuestionCircle, {
    className: props.iconClass
  })));
};

HelpIcon.propTypes = {
  text: PropTypes.string.isRequired,
  iconClassContainer: PropTypes.string,
  iconClass: PropTypes.string
};
HelpIcon.defaultProps = {
  iconClassContainer: '',
  iconClass: ''
};
export default HelpIcon;