import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import "core-js/modules/web.dom-collections.for-each";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PropTypes from 'prop-types';
import ReactDOM from 'react-dom';
import InputMask from 'inputmask-core';
import MaskMapper from '../util/MaskMapper';
import { ConfigurationContext } from '../contexts/ConfigurationContext';
var KEYCODE_Z = 90;
var KEYCODE_Y = 89;

function isUndo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Z;
}

function isRedo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Y;
} // Copied from https://github.com/insin/react-maskedinput


function getSelection(el) {
  var start;
  var end;
  var rangeEl;
  var clone;

  if (el.selectionStart !== undefined) {
    start = el.selectionStart;
    end = el.selectionEnd;
  } else {
    try {
      el.focus();
      rangeEl = el.createTextRange();
      clone = rangeEl.duplicate();
      rangeEl.moveToBookmark(document.selection.createRange().getBookmark());
      clone.setEndPoint('EndToStart', rangeEl);
      start = clone.text.length;
      end = start + rangeEl.text.length;
    } catch (e) {
      /* not focused or not visible */
    }
  }

  return {
    start: start,
    end: end
  };
}

function setSelection(el, selection) {
  var rangeEl;

  try {
    if (el.selectionStart !== undefined) {
      el.focus();
      el.setSelectionRange(selection.start, selection.end);
    } else {
      el.focus();
      rangeEl = el.createTextRange();
      rangeEl.collapse(true);
      rangeEl.moveStart('character', selection.start);
      rangeEl.moveEnd('character', selection.end - selection.start);
      rangeEl.select();
    }
  } catch (e) {
    /* not focused or not visible */
  }
}

var MaskedInput = /*#__PURE__*/function (_React$Component) {
  _inherits(MaskedInput, _React$Component);

  var _super = _createSuper(MaskedInput);

  function MaskedInput(_props) {
    var _this;

    _classCallCheck(this, MaskedInput);

    _this = _super.call(this, _props);

    _defineProperty(_assertThisInitialized(_this), "_updatePattern", function (props) {
      _this.mask.setPattern(MaskMapper.mapMask(props.mask), {
        value: _this.mask.getRawValue(),
        selection: getSelection(_this.input)
      });
    });

    _defineProperty(_assertThisInitialized(_this), "_updateMaskSelection", function () {
      _this.mask.selection = getSelection(_this.input);
    });

    _defineProperty(_assertThisInitialized(_this), "_updateInputSelection", function () {
      setSelection(_this.input, _this.mask.selection);
    });

    _defineProperty(_assertThisInitialized(_this), "_onChange", function (e) {
      var maskValue = _this.mask.getValue();

      if (e.target.value !== maskValue) {
        // Cut or delete operations will have shortened the value
        if (e.target.value.length < maskValue.length) {
          var sizeDiff = maskValue.length - e.target.value.length;

          _this._updateMaskSelection();

          _this.mask.selection.end = _this.mask.selection.start + sizeDiff;

          _this.mask.backspace();
        }

        var value = _this._getDisplayValue();

        e.target.value = value;

        if (value) {
          _this._updateInputSelection();
        }
      }

      if (_this.props.onChange) {
        _this.props.onChange(e);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_onKeyDown", function (e) {
      if (isUndo(e)) {
        e.preventDefault();

        if (_this.mask.undo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (isRedo(e)) {
        e.preventDefault();

        if (_this.mask.redo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (e.key === 'Backspace') {
        e.preventDefault();

        _this._updateMaskSelection();

        if (_this.mask.backspace()) {
          var value = _this._getDisplayValue();

          e.target.value = value;

          if (value) {
            _this._updateInputSelection();
          }

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_onKeyPress", function (e) {
      // Ignore modified key presses
      // Ignore enter key to allow form submission
      if (e.metaKey || e.altKey || e.ctrlKey || e.key === 'Enter') {
        return;
      }

      e.preventDefault();

      _this._updateMaskSelection();

      if (_this.mask.input(e.key)) {
        e.target.value = _this.mask.getValue();

        _this._updateInputSelection();

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_onPaste", function (e) {
      e.preventDefault();

      _this._updateMaskSelection(); // getData value needed for IE also works in FF & Chrome


      if (_this.mask.paste(e.clipboardData.getData('Text'))) {
        e.target.value = _this.mask.getValue(); // Timeout needed for IE

        setTimeout(_this._updateInputSelection, 0);

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _this.mask = new InputMask({
      pattern: MaskMapper.mapMask(_props.mask),
      value: _props.value,
      formatCharacters: _props.formatCharacters,
      placeholderChar: _props.placeholderChar || '_'
    });
    return _this;
  }

  _createClass(MaskedInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.mask !== this.props.mask) {
        this._updatePattern(this.props);
      }

      if (prevProps.mask !== this.props.mask && prevProps.value !== this.props.mask) {
        // if we get a new value and a new mask at the same time
        // check if the mask.value is still the initial value
        // - if so use the nextProps value
        // - otherwise the `this.mask` has a value for us (most likely from paste action)
        if (this.mask.getValue() === this.mask.emptyValue) {
          this.mask.setPattern(MaskMapper.mapMask(this.props.mask), {
            value: this.props.value
          });
        } else {
          this.mask.setPattern(MaskMapper.mapMask(this.props.mask), {
            value: this.mask.getRawValue()
          });
        }
      } else if (prevProps.mask !== this.props.mask) {
        this.mask.setPattern(MaskMapper.mapMask(this.props.mask), {
          value: this.mask.getRawValue()
        });
      } else if (prevProps.value !== this.props.value) {
        this.mask.setValue(this.props.value);
      }

      if (prevProps.mask !== this.props.mask && this.mask.selection.start) {
        this._updateInputSelection();
      }
    }
  }, {
    key: "_getDisplayValue",
    value: function _getDisplayValue() {
      var value = this.mask.getValue();
      return value === this.mask.emptyValue ? '' : value;
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          size = _this$props.size,
          placeholder = _this$props.placeholder,
          props = _objectWithoutProperties(_this$props, ["size", "placeholder"]),
          patternLength = this.mask.pattern.length;

      return React.createElement(this.context.inputComponent, _objectSpread(_objectSpread({}, props), {}, {
        ref: function ref(r) {
          if (r) {
            _this2.input = r.input ? ReactDOM.findDOMNode(r.input) : r;
          }
        },
        maxLength: patternLength,
        onChange: this._onChange,
        onKeyDown: this._onKeyDown,
        onKeyPress: this._onKeyPress,
        onPaste: this._onPaste,
        placeholder: placeholder || this.mask.emptyValue,
        size: size || patternLength,
        value: this._getDisplayValue(),
        type: 'text'
      }));
    }
  }]);

  return MaskedInput;
}(React.Component);

export { MaskedInput as default };
MaskedInput.contextType = ConfigurationContext;
MaskedInput.propTypes = {
  mask: PropTypes.string.isRequired
};
MaskedInput.defaultProps = {
  value: ''
};