import "core-js/modules/es.array.map";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PropTypes from 'prop-types';
import JsonLdUtils from 'jsonld-utils';
import * as Constants from '../constants/Constants';

var MediaContent = /*#__PURE__*/function (_React$Component) {
  _inherits(MediaContent, _React$Component);

  var _super = _createSuper(MediaContent);

  function MediaContent() {
    _classCallCheck(this, MediaContent);

    return _super.apply(this, arguments);
  }

  _createClass(MediaContent, [{
    key: "render",
    value: function render() {
      var mediaContent = JsonLdUtils.getJsonAttValue(this.props.question, Constants.HAS_MEDIA_CONTENT);

      if (!mediaContent) {
        return null;
      }

      return this._renderDangerously(mediaContent);
    }
  }, {
    key: "_renderDangerously",
    value: function _renderDangerously(mediaContent) {
      if (Array.isArray(mediaContent)) {
        return /*#__PURE__*/React.createElement("div", {
          className: "col-6"
        }, mediaContent.map(function (src) {
          return /*#__PURE__*/React.createElement("div", {
            key: 'media-' + src,
            className: "row embed-responsive-21by9 media-content-video-container mb-3"
          }, MediaContent.iframe(src));
        }));
      } else {
        return /*#__PURE__*/React.createElement("div", {
          className: "row"
        }, /*#__PURE__*/React.createElement("div", {
          className: "col-6 embed-responsive-21by9 media-content-video-container mb-3"
        }, MediaContent.iframe(mediaContent)));
      }
    }
  }], [{
    key: "iframe",
    value: function iframe(src) {
      return /*#__PURE__*/React.createElement("iframe", {
        src: src,
        className: "embed-responsive-item",
        allowFullScreen: true
      });
    }
  }]);

  return MediaContent;
}(React.Component);

export { MediaContent as default };
MediaContent.propTypes = {
  question: PropTypes.object.isRequired
};