import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.array.sort";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import "core-js/modules/es.string.trim";
import "core-js/modules/web.dom-collections.for-each";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import { Card, Accordion } from 'react-bootstrap';
import JsonLdUtils from 'jsonld-utils';
import PropTypes from 'prop-types';
import Answer from './Answer';
import * as Constants from '../constants/Constants';
import FormUtils from '../util/FormUtils';
import HelpIcon from './HelpIcon';
import JsonLdObjectMap from '../util/JsonLdObjectMap';
import QuestionAnswerProcessor from '../model/QuestionAnswerProcessor';
import ValidatorFactory from '../model/ValidatorFactory';
import JsonLdObjectUtils from '../util/JsonLdObjectUtils';
import PrefixIcon from './PrefixIcon';
import MediaContent from './MediaContent';
import { CaretSquareUp, CaretSquareDown, InfoCircle } from '../styles/icons';
import { ConfigurationContext } from '../contexts/ConfigurationContext'; // TODO Remove once the pretty layout is tested

var PRETTY_ANSWERABLE_LAYOUT = false;

var Question = /*#__PURE__*/function (_React$Component) {
  _inherits(Question, _React$Component);

  var _super = _createSuper(Question);

  function Question(props) {
    var _this;

    _classCallCheck(this, Question);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "onAnswerChange", function (answerIndex, change) {
      _this._onChange(Constants.HAS_ANSWER, answerIndex, change);
    });

    _defineProperty(_assertThisInitialized(_this), "onSubQuestionChange", function (subQuestionIndex, change) {
      _this._onChange(Constants.HAS_SUBQUESTION, subQuestionIndex, change);
    });

    _defineProperty(_assertThisInitialized(_this), "_toggleCollapse", function () {
      if (_this.props.collapsible) {
        _this.setState({
          expanded: !_this.state.expanded
        });
      }
    });

    JsonLdObjectMap.putObject(props.question['@id'], props.question);
    _this.state = {
      validator: null,
      expanded: !FormUtils.isCollapsed(props.question)
    };
    return _this;
  }

  _createClass(Question, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState({
        validator: ValidatorFactory.createValidator(this.props.question, this.context.options.intl)
      });
    }
  }, {
    key: "_onChange",
    value: function _onChange(att, valueIndex, newValue) {
      var newState = _objectSpread({}, this.props.question);

      newState[att][valueIndex] = newValue;

      if (att === Constants.HAS_ANSWER) {
        var result = this.state.validator(newValue);
        newState = _objectSpread(_objectSpread({}, newState), result);
      }

      JsonLdObjectMap.putObject(newState['@id'], newState);
      this.props.onChange(this.props.index, newState);
    }
  }, {
    key: "render",
    value: function render() {
      var question = this.props.question;

      if (FormUtils.isHidden(question)) {
        return null;
      }

      if (!FormUtils.isRelevant(question)) {
        return null;
      }

      if (FormUtils.isAnswerable(question)) {
        if (PRETTY_ANSWERABLE_LAYOUT) {
          return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
            className: "panel-title answerable-question"
          }, this.renderAnswers()), /*#__PURE__*/React.createElement("div", {
            className: "answerable-subquestions"
          }, this.renderSubQuestions()));
        } else {
          return /*#__PURE__*/React.createElement("div", null, this.renderAnswers(), /*#__PURE__*/React.createElement("div", {
            className: "ml-4 mt-n2"
          }, this.renderSubQuestions()));
        }
      }

      if (FormUtils.isSection(question)) {
        var _this$props = this.props,
            collapsible = _this$props.collapsible,
            withoutCard = _this$props.withoutCard;

        if (withoutCard) {
          return /*#__PURE__*/React.createElement("div", null, this._renderQuestionContent());
        }

        var label = JsonLdUtils.getLocalized(question[JsonLdUtils.RDFS_LABEL], this.context.options.intl);
        var cardBody = /*#__PURE__*/React.createElement(Card.Body, {
          className: "p-3"
        }, this._renderQuestionContent());
        var headerClassName = "bg-info text-white ".concat(collapsible ? 'cursor-pointer' : '').trim(); // TODO change defaultActiveKey to label when expanded + add eventKey to Accordion.Collapse

        return /*#__PURE__*/React.createElement(Accordion, {
          defaultActiveKey: !this.state.expanded ? label : undefined
        }, /*#__PURE__*/React.createElement(Card, {
          className: "mb-3"
        }, /*#__PURE__*/React.createElement(Accordion.Toggle, {
          as: Card.Header,
          onClick: this._toggleCollapse,
          className: headerClassName
        }, /*#__PURE__*/React.createElement("h6", {
          className: "d-inline"
        }, collapsible && this._renderCollapseToggle(), label), this._renderQuestionHelp()), collapsible ? /*#__PURE__*/React.createElement(Accordion.Collapse, null, cardBody) : {
          cardBody: cardBody
        }));
      } else {
        return /*#__PURE__*/React.createElement("div", null, this._renderQuestionContent());
      }
    }
  }, {
    key: "_renderQuestionContent",
    value: function _renderQuestionContent() {
      var content = [];

      if (this.state.expanded) {
        content.push( /*#__PURE__*/React.createElement(MediaContent, {
          key: this.props.question['@id'] + '-media',
          question: this.props.question
        }));
      }

      content.push(this.renderAnswers());
      content.push(this.renderSubQuestions());
      return content;
    }
  }, {
    key: "renderAnswers",
    value: function renderAnswers() {
      var question = this.props.question,
          children = [],
          answers = this._getAnswers();

      var row = [],
          cls,
          isTextarea;

      for (var _i = 0, len = answers.length; _i < len; _i++) {
        isTextarea = FormUtils.isTextarea(this.props.question, FormUtils.resolveValue(answers[_i])) || FormUtils.isSparqlInput(question) || FormUtils.isTurtleInput(question);
        cls = Question._getAnswerClass(isTextarea);
        row.push( /*#__PURE__*/React.createElement("div", {
          key: 'row-item-' + _i,
          className: cls
        }, /*#__PURE__*/React.createElement("div", {
          className: "row"
        }, /*#__PURE__*/React.createElement("div", {
          className: "col-10"
        }, /*#__PURE__*/React.createElement(Answer, {
          index: _i,
          answer: answers[_i],
          question: question,
          onChange: this.onAnswerChange
        })), /*#__PURE__*/React.createElement("div", null, this._renderUnits(), this._renderQuestionHelp(), this._renderPrefixes()))));

        if (row.length === Constants.GENERATED_ROW_SIZE || isTextarea) {
          children.push( /*#__PURE__*/React.createElement("div", {
            className: "row",
            key: 'question-row-' + _i
          }, row));
          row = [];
        }
      }

      if (row.length > 0) {
        children.push( /*#__PURE__*/React.createElement("div", {
          className: "row",
          key: 'question-row-' + i
        }, row));
      }

      return children;
    }
  }, {
    key: "_getAnswers",
    value: function _getAnswers() {
      var question = this.props.question;

      if (!question[Constants.HAS_ANSWER]) {
        question[Constants.HAS_ANSWER] = [];
      }

      if (!Array.isArray(question[Constants.HAS_ANSWER])) {
        question[Constants.HAS_ANSWER] = [question[Constants.HAS_ANSWER]];
      }

      if (question[Constants.HAS_ANSWER].length === 0) {
        if (FormUtils.isSection(question) && !FormUtils.isAnswerable(question) || FormUtils.isWizardStep(question)) {
          question[Constants.HAS_ANSWER] = [];
        } else {
          question[Constants.HAS_ANSWER] = [QuestionAnswerProcessor.generateAnswer(question)];
        }
      }

      return question[Constants.HAS_ANSWER];
    }
  }, {
    key: "_renderCollapseToggle",
    value: function _renderCollapseToggle() {
      var title = this.state.expanded ? 'Collapse' : 'Expand';
      return /*#__PURE__*/React.createElement("span", {
        onClick: this._toggleCollapse,
        title: title
      }, this.state.expanded ? /*#__PURE__*/React.createElement(CaretSquareUp, null) : /*#__PURE__*/React.createElement(CaretSquareDown, null));
    }
  }, {
    key: "_renderQuestionHelp",
    value: function _renderQuestionHelp() {
      var question = this.props.question;
      var helpClass = FormUtils.isCheckbox(question) ? 'help-icon-checkbox' : 'help-icon-text-input';

      if (FormUtils.isSection(question)) {
        helpClass = 'help-icon-section';
      }

      return question[Constants.HELP_DESCRIPTION] ? /*#__PURE__*/React.createElement(HelpIcon, {
        text: JsonLdUtils.getLocalized(question[Constants.HELP_DESCRIPTION], this.context.options.intl),
        iconClassContainer: helpClass
      }) : null;
    }
  }, {
    key: "_renderPrefixes",
    value: function _renderPrefixes() {
      var question = this.props.question;
      return question[Constants.HAS_DECLARED_PREFIX] && question[Constants.HAS_DECLARED_PREFIX].length ? /*#__PURE__*/React.createElement(PrefixIcon, {
        prefixes: question[Constants.HAS_DECLARED_PREFIX],
        iconClass: 'help-icon-checkbox'
      }, /*#__PURE__*/React.createElement(InfoCircle, null)) : null;
    }
  }, {
    key: "_renderUnits",
    value: function _renderUnits() {
      var question = this.props.question;
      return question[Constants.HAS_UNIT] ? /*#__PURE__*/React.createElement("div", {
        className: "has-unit-label"
      }, question[Constants.HAS_UNIT]) : null;
    }
  }, {
    key: "renderSubQuestions",
    value: function renderSubQuestions() {
      var children = [];

      var subQuestions = this._getSubQuestions();

      for (var _i2 = 0; _i2 < subQuestions.length; _i2++) {
        children.push( /*#__PURE__*/React.createElement(Question, {
          key: 'sub-question-' + _i2,
          index: _i2,
          question: subQuestions[_i2],
          onChange: this.onSubQuestionChange
        }));
      }

      return children;
    }
  }, {
    key: "_getSubQuestions",
    value: function _getSubQuestions() {
      var question = this.props.question;

      if (!question[Constants.HAS_SUBQUESTION]) {
        question[Constants.HAS_SUBQUESTION] = [];
      }

      if (!Array.isArray(question[Constants.HAS_SUBQUESTION])) {
        question[Constants.HAS_SUBQUESTION] = [question[Constants.HAS_SUBQUESTION]];
      } // sort by label


      question[Constants.HAS_SUBQUESTION].sort(JsonLdObjectUtils.getCompareLocalizedLabelFunction(this.context.options.intl)); // sort by property

      JsonLdObjectUtils.orderPreservingToplogicalSort(question[Constants.HAS_SUBQUESTION], Constants.HAS_PRECEDING_QUESTION);
      return question[Constants.HAS_SUBQUESTION];
    }
  }], [{
    key: "_getAnswerClass",
    value: function _getAnswerClass(isTextarea) {
      return isTextarea ? 'col-12' : Constants.GENERATED_ROW_SIZE === 1 ? 'col-6' : 'col-' + Constants.COLUMN_COUNT / Constants.GENERATED_ROW_SIZE;
    }
  }]);

  return Question;
}(React.Component);

export { Question as default };
Question.contextType = ConfigurationContext;
Question.propTypes = {
  question: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
  index: PropTypes.number,
  withoutCard: PropTypes.bool,
  collapsible: PropTypes.bool // Whether the section is collapsible (if the question is a section)

};
Question.defaultProps = {
  withoutCard: false,
  collapsible: true
};