import _extends from "@babel/runtime/helpers/extends";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import "regenerator-runtime/runtime";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import React, { forwardRef, useEffect, useState } from 'react';
import PropTypes from 'prop-types';
import { FormGenContextProvider } from '../contexts/FormGenContext';
import { WizardContextProvider } from '../contexts/WizardContext';
import { ConfigurationContextProvider } from '../contexts/ConfigurationContext';
import WizardGenerator from '../model/WizardGenerator';
import FormManager from './FormManager';
var SForms = forwardRef(function (props, ref) {
  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      loading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      wizardProperties = _useState4[0],
      setWizardProperties = _useState4[1];

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      form = _useState6[0],
      setForm = _useState6[1];

  useEffect(function () {
    var buildWizard = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
        var intl, _yield$WizardGenerato, _yield$WizardGenerato2, wizardProperties, structure;

        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                intl = props.options.intl;
                _context.next = 3;
                return WizardGenerator.createWizard(props.form, props.formData, null, intl);

              case 3:
                _yield$WizardGenerato = _context.sent;
                _yield$WizardGenerato2 = _slicedToArray(_yield$WizardGenerato, 2);
                wizardProperties = _yield$WizardGenerato2[0];
                structure = _yield$WizardGenerato2[1];

                if (wizardProperties.steps.length > 0) {
                  wizardProperties.steps[0].visited = true;
                }

                setWizardProperties(wizardProperties);
                setForm(structure);
                setLoading(false);

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function buildWizard() {
        return _ref.apply(this, arguments);
      };
    }();

    buildWizard();
  }, []);

  if (loading) {
    return props.loader || /*#__PURE__*/React.createElement("div", null, "'Loading SForms...'");
  }

  return /*#__PURE__*/React.createElement(ConfigurationContextProvider, {
    components: props.components,
    componentsOptions: props.componentsOptions,
    options: props.options
  }, /*#__PURE__*/React.createElement(FormGenContextProvider, {
    fetchTypeAheadValues: props.fetchTypeAheadValues
  }, /*#__PURE__*/React.createElement(WizardContextProvider, {
    data: form,
    steps: wizardProperties.steps,
    isFormValid: props.isFormValid
  }, /*#__PURE__*/React.createElement(FormManager, _extends({
    ref: ref
  }, props)))));
});
SForms.propTypes = {
  form: PropTypes.object.isRequired,
  formData: PropTypes.object,
  options: PropTypes.object.isRequired,
  components: PropTypes.object,
  componentsOptions: PropTypes.object,
  fetchTypeAheadValues: PropTypes.func,
  isFormValid: PropTypes.func,
  loader: PropTypes.element
};
export default SForms;