import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/web.dom-collections.for-each";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useContext } from 'react';
import PropTypes from 'prop-types';
import FormUtils from '../../util/FormUtils';
import * as Constants from '../../constants/Constants';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _classCallCheck(this, InputPropertiesResolver);
  }

  _createClass(InputPropertiesResolver, null, [{
    key: "resolveValidationProperties",
    value: function resolveValidationProperties(question) {
      var props = {};

      if (question[Constants.HAS_VALID_ANSWER] === false) {
        props['validation'] = 'error';
        props['help'] = question[Constants.HAS_VALIDATION_MESSAGE];
      }

      return props;
    }
  }]);

  return InputPropertiesResolver;
}();

var CheckboxAnswer = function CheckboxAnswer(props) {
  var _useContext = useContext(ConfigurationContext),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  return React.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveValidationProperties(question)), {}, {
    type: 'checkbox',
    label: props.label,
    title: props.title,
    checked: props.value === true || props.value === 'true',
    onChange: function onChange(e) {
      props.onChange(e.target.checked);
    },
    disabled: componentsOptions.readOnly || FormUtils.isDisabled(question)
  }));
};

CheckboxAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
  onChange: PropTypes.func.isRequired
};
export default CheckboxAnswer;