import React, { useContext } from 'react';
import JsonLdUtils from 'jsonld-utils';
import PropTypes from 'prop-types';
import * as Constants from '../../constants/Constants';
import FormUtils from '../../util/FormUtils';
import InputAnswer from './InputAnswer';
import Logger from '../../util/Logger';
import MaskedInput from '../MaskedInput';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var MaskedInputAnswer = function MaskedInputAnswer(props) {
  var _useContext = useContext(ConfigurationContext),
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var value = props.value;
  var mask = JsonLdUtils.getJsonAttValue(question, Constants.INPUT_MASK);

  if (!mask) {
    Logger.warn('Input mask not provided. Falling back to regular input.');
    return /*#__PURE__*/React.createElement(InputAnswer, props);
  }

  return /*#__PURE__*/React.createElement(MaskedInput, {
    mask: mask,
    value: value,
    label: props.label,
    title: props.title,
    placeholder: mask,
    onChange: function onChange(e) {
      return props.onChange(e.target.value);
    },
    disabled: componentsOptions.readOnly || FormUtils.isDisabled(question)
  });
};

MaskedInputAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  answer: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  onChange: PropTypes.func.isRequired
};
export default MaskedInputAnswer;