import "core-js/modules/es.array.sort";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.reflect.construct";
import "core-js/modules/es.regexp.to-string";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import JsonLdUtils from 'jsonld-utils';
import PropTypes from 'prop-types';
import * as Constants from '../../constants/Constants';
import FormUtils from '../../util/FormUtils';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var SelectAnswer = /*#__PURE__*/function (_React$Component) {
  _inherits(SelectAnswer, _React$Component);

  var _super = _createSuper(SelectAnswer);

  function SelectAnswer() {
    _classCallCheck(this, SelectAnswer);

    return _super.apply(this, arguments);
  }

  _createClass(SelectAnswer, [{
    key: "_generateSelectOptions",
    value: function _generateSelectOptions(options) {
      var rendered = [];
      options.sort(function (a, b) {
        var aLabel = JsonLdUtils.getJsonAttValue(a, JsonldUtils.RDFS_LABEL),
            bLabel = JsonLdUtils.getJsonAttValue(b, JsonldUtils.RDFS_LABEL);

        if (aLabel < bLabel) {
          return -1;
        }

        if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      });

      for (var i = 0, len = options.length; i < len; i++) {
        rendered.push( /*#__PURE__*/React.createElement("option", {
          value: JsonLdUtils.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL),
          key: 'opt-' + i
        }, JsonLdUtils.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL)));
      }

      return rendered;
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var question = this.props.question;
      return React.createElement(this.context.inputComponent, {
        type: 'select',
        label: this.props.label,
        value: this.props.value,
        title: this.props.title,
        onChange: function onChange(e) {
          _this.props.onChange(e.target.value);
        },
        disabled: this.context.componentsOptions.readOnly || FormUtils.isDisabled(question)
      }, this._generateSelectOptions(question[Constants.HAS_OPTION]));
    }
  }]);

  return SelectAnswer;
}(React.Component);

export { SelectAnswer as default };
SelectAnswer.contextType = ConfigurationContext;
SelectAnswer.propTypes = {
  question: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
  title: PropTypes.string,
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired
};