import "core-js/modules/es.array.map";
import React, { useContext } from 'react';
import { ListGroup, ListGroupItem } from 'react-bootstrap';
import PropTypes from 'prop-types';
import JsonLdUtils from 'jsonld-utils';
import { ConfigurationContext } from '../../contexts/ConfigurationContext'; //TODO add "disabled" to VerticalWizardNav

var VerticalWizardNav = function VerticalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = useContext(ConfigurationContext),
      options = _useContext.options;

  return /*#__PURE__*/React.createElement("div", {
    className: "wizard-nav col-2 p-0"
  }, /*#__PURE__*/React.createElement(ListGroup, null, steps.map(function (step, index) {
    return /*#__PURE__*/React.createElement(ListGroupItem, {
      key: 'nav' + index,
      onClick: function onClick() {
        return onNavigate(index);
      },
      id: 'wizard-nav-' + index,
      active: index === currentStep ? 'active' : ''
    }, JsonLdUtils.getLocalized(step[JsonLdUtils.RDFS_LABEL], options.intl));
  })));
};

VerticalWizardNav.propTypes = {
  currentStep: PropTypes.number.isRequired,
  steps: PropTypes.array.isRequired,
  onNavigate: PropTypes.func.isRequired
};
export default VerticalWizardNav;