import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

var _this = this;

import React, { useState } from 'react';
import { Alert, Button, ButtonToolbar, Card } from 'react-bootstrap';
import JsonLdUtils from 'jsonld-utils';
import PropTypes from 'prop-types';
import * as Constants from '../../constants/Constants';
import HelpIcon from '../HelpIcon';
import { WizardContext } from '../../contexts/WizardContext';
import GeneratedStep from '../GeneratedStep';
import { ConfigurationContext } from '../../contexts/ConfigurationContext';

var WizardStep = function WizardStep(props) {
  var wizardContext = React.useContext(WizardContext);

  var _React$useContext = React.useContext(ConfigurationContext),
      options = _React$useContext.options;

  var _useState = useState(props.step.defaultNextDisabled != null ? props.step.defaultNextDisabled : false),
      _useState2 = _slicedToArray(_useState, 2),
      advanceDisabled = _useState2[0],
      setAdvanceDisabled = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      retreatDisabled = _useState4[0],
      setRetreatDisabled = _useState4[1];

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      currentError = _useState6[0],
      setCurrentError = _useState6[1];

  var onAdvance = function onAdvance(err) {
    if (err) {
      setAdvanceDisabled(true);
      setRetreatDisabled(true);
      setCurrentError(err);
    } else {
      wizardContext.updateStepData(props.stepIndex, wizardContext.getStepData());
      props.onAdvance();
    }
  };

  var onNext = function onNext() {
    setAdvanceDisabled(true);
    setRetreatDisabled(true);

    if (props.step.onNext) {
      props.step.onNext.apply(_this, [onAdvance]);
    } else {
      wizardContext.updateStepData(props.stepIndex, wizardContext.getStepData());
      props.onAdvance();
    }
  };

  var onPrevious = function onPrevious() {
    if (props.step.onPrevious) {
      props.step.onPrevious.apply(_this, [props.onRetreat]);
    } else {
      props.onRetreat();
    }
  };

  var onFinish = function onFinish() {
    wizardContext.updateStepData(props.stepIndex, wizardContext.getStepData());
    props.onFinish();
  };

  var enableNext = function enableNext() {
    return setAdvanceDisabled(false);
  };

  var disableNext = function disableNext() {
    return setAdvanceDisabled(true);
  };

  var renderAdvanceButton = function renderAdvanceButton() {
    if (!props.isLastStep) {
      return /*#__PURE__*/React.createElement(Button, {
        onClick: onNext,
        disabled: advanceDisabled,
        variant: "primary",
        size: "sm"
      }, options.i18n['wizard.next']);
    }

    return null;
  };

  var _renderHelpIcon = function _renderHelpIcon() {
    var question = wizardContext.getStepData([props.stepIndex]);
    return question[Constants.HELP_DESCRIPTION] ? /*#__PURE__*/React.createElement(HelpIcon, {
      text: JsonLdUtils.getLocalized(question[Constants.HELP_DESCRIPTION], options.intl),
      iconClass: "help-icon-section"
    }) : null;
  };

  return /*#__PURE__*/React.createElement("div", {
    className: "wizard-step"
  }, /*#__PURE__*/React.createElement(Card, {
    className: "wizard-step-content"
  }, /*#__PURE__*/React.createElement(Card.Header, {
    className: "bg-info text-white",
    as: "h6"
  }, JsonLdUtils.getLocalized(props.step[JsonLdUtils.RDFS_LABEL], options.intl), _renderHelpIcon()), /*#__PURE__*/React.createElement(Card.Body, null, /*#__PURE__*/React.createElement(GeneratedStep, {
    stepIndex: props.stepIndex,
    question: props.step
  }))), /*#__PURE__*/React.createElement(ButtonToolbar, {
    className: "m-3 float-right"
  }, !props.isFirstStep && /*#__PURE__*/React.createElement(Button, {
    className: "mr-2",
    onClick: onPrevious,
    disabled: retreatDisabled,
    variant: "primary",
    size: "sm"
  }, options.i18n['wizard.previous']), renderAdvanceButton()), currentError && /*#__PURE__*/React.createElement(Alert, {
    variant: "danger"
  }, /*#__PURE__*/React.createElement("p", null, currentError.message)));
};

WizardStep.propTypes = {
  step: PropTypes.object.isRequired,
  onFinish: PropTypes.func.isRequired,
  onAdvance: PropTypes.func,
  onRetreat: PropTypes.func,
  stepIndex: PropTypes.number.isRequired,
  isFirstStep: PropTypes.bool,
  isLastStep: PropTypes.bool
};
export default WizardStep;