import "core-js/modules/es.symbol";
import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.for-each";
import "core-js/modules/es.object.get-own-property-descriptor";
import "core-js/modules/es.object.get-own-property-descriptors";
import "core-js/modules/es.object.keys";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.promise";
import "core-js/modules/web.dom-collections.for-each";
import _extends from "@babel/runtime/helpers/extends";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import "regenerator-runtime/runtime";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useMemo, useState } from 'react';
import PropTypes from 'prop-types';
import jsonld from 'jsonld';
import Logger from '../util/Logger';
var FormGenContext = React.createContext({});

var FormGenContextProvider = function FormGenContextProvider(_ref) {
  var children = _ref.children,
      props = _objectWithoutProperties(_ref, ["children"]);

  var _useState = useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      options = _useState2[0],
      setOptions = _useState2[1];

  var loadFormOptions = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(id, query) {
      var option, data;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              option = options[id];

              if (!(option && option.length)) {
                _context.next = 3;
                break;
              }

              return _context.abrupt("return", option);

            case 3:
              _context.next = 5;
              return props.fetchTypeAheadValues(query);

            case 5:
              data = _context.sent;

              if (!data.length) {
                _context.next = 8;
                break;
              }

              return _context.abrupt("return", new Promise(function (resolve) {
                jsonld.frame(data, {}, null, function (err, framed) {
                  var option = framed['@graph'];
                  setOptions(function (prevState) {
                    return _objectSpread(_objectSpread({}, prevState), {}, _defineProperty({}, id, option));
                  });
                  return resolve(option);
                });
              }));

            case 8:
              Logger.warn("No data received when loading options using id ".concat(id));
              return _context.abrupt("return", []);

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function loadFormOptions(_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }();

  var getOptions = function getOptions(id) {
    return options[id] || [];
  };

  var values = useMemo(function () {
    return {
      loadFormOptions: loadFormOptions,
      getOptions: getOptions
    };
  }, [loadFormOptions, getOptions]);
  return /*#__PURE__*/React.createElement(FormGenContext.Provider, _extends({
    value: values
  }, props), children);
};

FormGenContextProvider.propTypes = {
  children: PropTypes.element.isRequired,
  fetchTypeAheadValues: PropTypes.func
};
export { FormGenContext, FormGenContextProvider };