import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";

/**
 * Created by blcha on 4.11.16.
 */
import JsonLdUtils from 'jsonld-utils';
import * as Constants from '../constants/Constants';
import FormUtils from '../util/FormUtils';

var ValidatorFactory = /*#__PURE__*/function () {
  function ValidatorFactory() {
    _classCallCheck(this, ValidatorFactory);
  }

  _createClass(ValidatorFactory, null, [{
    key: "createValidator",
    value: function createValidator(question, intl) {
      if (question[Constants.REQUIRES_ANSWER]) {
        if (FormUtils.isCheckbox(question)) {
          //TODO revise
          return ValidatorFactory._generateRequiresAnswerCheckBoxValidator(question, intl);
        }

        return ValidatorFactory._generateRequiresAnswerValidator(question, intl);
      } else {
        return function () {
          var result = {};
          result[Constants.HAS_VALID_ANSWER] = true;
          delete result[Constants.HAS_VALIDATION_MESSAGE];
          return result;
        };
      }
    }
  }, {
    key: "_generateRequiresAnswerValidator",
    value: function _generateRequiresAnswerValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[Constants.HAS_DATA_VALUE]) {
          val = JsonLdUtils.getJsonAttValue(answer, Constants.HAS_DATA_VALUE);
        } else if (answer[Constants.HAS_OBJECT_VALUE]) {
          val = JsonLdUtils.getJsonAttValue(answer, Constants.HAS_OBJECT_VALUE, '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '';
        var result = {};
        result[Constants.HAS_VALID_ANSWER] = isValid;
        result[Constants.HAS_VALIDATION_MESSAGE] = isValid ? null : JsonLdUtils.getLocalized(question[JsonLdUtils.RDFS_LABEL], intl) + ' is missing a value.';
        return result;
      };
    }
  }, {
    key: "_generateRequiresAnswerCheckBoxValidator",
    value: function _generateRequiresAnswerCheckBoxValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[Constants.HAS_DATA_VALUE]) {
          val = JsonLdUtils.getJsonAttValue(answer, Constants.HAS_DATA_VALUE);
        } else if (answer[Constants.HAS_OBJECT_VALUE]) {
          val = JsonLdUtils.getJsonAttValue(answer, Constants.HAS_OBJECT_VALUE, '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '' && val !== false;
        var result = {};
        result[Constants.HAS_VALID_ANSWER] = isValid;
        result[Constants.HAS_VALIDATION_MESSAGE] = isValid ? null : JsonLdUtils.getLocalized(question[JsonLdUtils.RDFS_LABEL], intl) + ' must be checked.';
        return result;
      };
    }
  }]);

  return ValidatorFactory;
}();

export { ValidatorFactory as default };