import "core-js/modules/es.array.filter";
import "core-js/modules/es.array.find";
import "core-js/modules/es.array.map";
import "core-js/modules/es.array.sort";
import "core-js/modules/es.object.keys";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.promise";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import jsonld from 'jsonld';
import * as Constants from '../constants/Constants';
import DefaultFormGenerator from './DefaultFormGenerator';
import FormUtils from '../util/FormUtils';
import Logger from '../util/Logger';
import JsonLdFramingUtils from '../util/JsonLdFramingUtils';
import JsonLdObjectUtils from '../util/JsonLdObjectUtils';
import JsonLdObjectMap from '../util/JsonLdObjectMap';

var WizardGenerator = /*#__PURE__*/function () {
  function WizardGenerator() {
    _classCallCheck(this, WizardGenerator);
  }

  _createClass(WizardGenerator, null, [{
    key: "createDefaultWizard",

    /**
     * Generates a default, one-step wizard.
     *
     * @param data Optional, data for which the wizard should be generated (i.e. the root question)
     * @param title Optional, title of the wizard
     * @return Wizard steps definitions (an array of one element in this case) and form data
     */
    value: function createDefaultWizard(data, title, intl) {
      var defaultFormData = DefaultFormGenerator.generateForm(data);

      var _WizardGenerator$_con = WizardGenerator._constructWizardSteps(defaultFormData, intl),
          _WizardGenerator$_con2 = _slicedToArray(_WizardGenerator$_con, 2),
          steps = _WizardGenerator$_con2[0],
          form = _WizardGenerator$_con2[1];

      var wizardProperties = {
        steps: steps,
        title: title
      };
      return [wizardProperties, form];
    }
    /**
     * Generates wizard steps from the specified data-enriched template.
     * @param structure The wizard structure in JSON-LD
     * @param data Optional, data for which the wizard will be generated (i.e. the root question)
     * @param title Optional, wizard title
     * @return Promise with generated wizard step definitions and form data
     */

  }, {
    key: "createWizard",
    value: function createWizard(structure, data, title, intl) {
      return new Promise(function (resolve) {
        return jsonld.flatten(structure, {}, null, function (err, structure) {
          var wizardProperties;
          var form;

          if (err) {
            Logger.error(err);
          }

          try {
            var _WizardGenerator$_con3 = WizardGenerator._constructWizardSteps(structure, intl),
                _WizardGenerator$_con4 = _slicedToArray(_WizardGenerator$_con3, 2),
                steps = _WizardGenerator$_con4[0],
                rootForm = _WizardGenerator$_con4[1];

            form = rootForm;
            wizardProperties = {
              steps: steps,
              title: title
            };
          } catch (e) {
            wizardProperties = WizardGenerator.createDefaultWizard(data, title);
          }

          return resolve([wizardProperties, form]);
        });
      });
    }
  }, {
    key: "_constructWizardSteps",
    value: function _constructWizardSteps(structure, intl) {
      var form;
      var formElements;
      var id2ObjectMap;
      var stepQuestions = [];

      if (structure['@graph'][0]['@id'] !== undefined) {
        id2ObjectMap = JsonLdFramingUtils.modifyStructure(structure); //TODO make as callback

        Object.keys(id2ObjectMap).map(function (key) {
          JsonLdObjectMap.putObject(key, id2ObjectMap[key]);
        });
      } else {
        console.warn('default form is constructed.');
      }

      form = structure['@graph'].find(function (item) {
        return FormUtils.isForm(item);
      });
      formElements = form[Constants.HAS_SUBQUESTION];

      if (!formElements) {
        Logger.error('Could not find any wizard steps in the received data.');
        throw 'No wizard steps in form';
      }

      stepQuestions = formElements.filter(function (item) {
        if (FormUtils.isWizardStep(item) && !FormUtils.isHidden(item)) {
          return true;
        }

        Logger.warn('Item is not a wizard step: ' + item);
        return false;
      }); // sort by label

      stepQuestions.sort(JsonLdObjectUtils.getCompareLocalizedLabelFunction(intl)); // sort by property

      JsonLdObjectUtils.orderPreservingToplogicalSort(stepQuestions, Constants.HAS_PRECEDING_QUESTION);
      return [stepQuestions, {
        root: form
      }];
    }
  }]);

  return WizardGenerator;
}();

export { WizardGenerator as default };